/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.authorization;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.authorization.CalcWhereConditionEventContext;

public class CalcWhereConditionEventContextImpl extends EventContextDelegator implements CalcWhereConditionEventContext {

	public CalcWhereConditionEventContextImpl(EventContext eventContext) {
		super(eventContext);
	}
		
	@Override
	public AuthorizationService getService() {
		return (AuthorizationService)super.getService();
	}
	
	private static final String PARAM_ENTITY_NAME = "entityName"; 
	
	private static final String PARAM_EVENT_NAME = "eventName";
	
	private static final String PARAM_RESULT = "result";

	// IN
	public void setEntityName(String entity) {
		put(PARAM_ENTITY_NAME, entity);
	}

	public String getEntityName() {
		return (String)get(PARAM_ENTITY_NAME);
	}

	public void setEventName(String event) {
		put(PARAM_EVENT_NAME, event);
	}

	public String getEventName() {
		return (String)get(PARAM_EVENT_NAME);
	}

	// OUT
	public CqnPredicate getResult() {
		return (CqnPredicate)get(PARAM_RESULT);
	}

	public void setResult(CqnPredicate result) {
		put(PARAM_RESULT, result);
		setCompleted();
	}
}
