/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.cds;

import java.util.Set;
import java.util.stream.Collectors;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.utils.OrderConstants;

@ServiceName(value = "*", type = {ApplicationService.class})
public class ValidationErrorHandler implements EventHandler {

	private final static String previousMessagesKey = "cds.internal.validations.previousMessages";

	@Before
	@HandlerOrder(OrderConstants.Before.CHECK_CAPABILITIES + 1)
	public void keepPreviousMessages(EventContext context) {
		Set<Message> previousMessages = context.getMessages().stream().collect(Collectors.toSet());
		context.put(previousMessagesKey, previousMessages);
	}

	@Before
	@HandlerOrder(OrderConstants.Before.THROW_IF_ERROR)
	@SuppressWarnings("unchecked")
	public void throwIfError(EventContext context) {
		if (context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().isCombined()) {
			Set<Message> previousMessages = (Set<Message>) context.get(previousMessagesKey);
			if (context.getMessages().stream().anyMatch(m -> !previousMessages.contains(m) && m.getSeverity().equals(Message.Severity.ERROR))) {
				context.getMessages().throwIfError();
			}
		}
	}

}
