/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;

/**
 * Describes how to resolve a certain argument value on a given {@link EventContext}
 */
public interface ArgumentResolver {

	/**
	 * Finds an argument value on the given {@link EventContext}
	 *
	 * @param context the {@link EventContext} currently processed
	 * @return the determined argument value
	 */
	Object resolve(EventContext context);

	/**
	 * Verifies the resolver, based on the final {@link HandlerDescriptor}.
	 * @param descriptor the {@link HandlerDescriptor}
	 *
	 * @throws IllegalArgumentException if the verification failed
	 */
	void verifyOrThrow(HandlerDescriptor descriptor);

	/**
	 * @return an array of indicated events, that can be used if the handler does not specify events in their annotation
	 */
	default String[] indicateEvents() {
		return new String[0];
	}

	/**
	 * @return an array of indicated entities, that can be used if the handler does not specify entities in their annotation
	 */
	default String[] indicateEntities() {
		return new String[0];
	}

}
