/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.runtime.mockusers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.authentication.BasicAuthenticationInfo;
import com.sap.cds.services.environment.CdsProperties.Security.Mock;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.FeatureTogglesInfoProvider;

public class MockedFeatureTogglesProvider implements FeatureTogglesInfoProvider {

    private final CdsRuntime runtime;

    public MockedFeatureTogglesProvider(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public FeatureTogglesInfo get(UserInfo userInfo, ParameterInfo parameterInfo) {
        AuthenticationInfo authInfo = runtime.getProvidedAuthenticationInfo();
        if (authInfo != null && authInfo.is(BasicAuthenticationInfo.class)) {
        	Mock mockConfig = runtime.getEnvironment().getCdsProperties().getSecurity().getMock();
        	List<String> features = mockConfig.getUsers().values().stream()
        			.filter(u -> u.getName() != null && u.getName().equals(userInfo.getName()))
        			.findFirst().map(u -> u.getFeatures()).orElse(null);
        	if (features == null) {
        		features = mockConfig.getTenants().values().stream()
        				.filter(t -> t.getName() != null && t.getName().equals(userInfo.getTenant()))
        				.findFirst().map(t -> t.getFeatures()).orElse(null);
        	}

        	if (features != null) {
	        	Map<String, Boolean> featureToggles = new HashMap<>();
	        	features.stream().forEach(f -> featureToggles.put(f, true));
	        	return FeatureTogglesInfo.create(featureToggles);
        	}
        }

        return null;
    }
}
