package com.sap.cds.services.impl.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;

import com.sap.cds.services.environment.CdsProperties.Errors;
import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.utils.LocaleUtils;

public class DefaultTranslationUtils {

	public final static String BUNDLE_NAME = "com.sap.cds.i18n.errors";
	private final static Set<String> KEYS = ResourceBundle.getBundle(BUNDLE_NAME, Locale.ROOT).keySet();

	public static String getLocalizedMessage(LocalizedMessageProvider provider, String code, Object[] args, Locale locale, Errors config) {
		String localized = provider.get(code, args, locale);
		if (config.getDefaultTranslations().isEnabled() && KEYS.contains(code) && Objects.equals(code, localized)) {
			Locale theLocale = locale == null ? Locale.getDefault() : LocaleUtils.getLocaleForBundle(locale);
			ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME, theLocale);
			if (bundle.containsKey(code)) {
				return new MessageFormat(bundle.getString(code), theLocale).format(args);
			}
		}
		return localized; // no default translation available or desired
	}

}
