/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.application;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationStoppedEventContext;
import com.sap.cds.services.application.ErrorResponseEventContext;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLifecycleServiceImpl
extends ServiceDelegator
implements ApplicationLifecycleService {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationLifecycleServiceImpl.class);

    public ApplicationLifecycleServiceImpl(String name) {
        super(name);
    }

    public void applicationPrepared() {
        this.emit((EventContext)ApplicationPreparedEventContext.create());
    }

    public void applicationStopped() {
        this.emit((EventContext)ApplicationStoppedEventContext.create());
    }

    public ErrorResponseEventContext.ErrorResponse errorResponse(ServiceException exception) {
        ErrorResponseEventContext context = ErrorResponseEventContext.create();
        context.setException(Objects.requireNonNull(exception, "exception must not be null"));
        this.emit((EventContext)context);
        ErrorResponseEventContext.ErrorResponse result = context.getResult();
        if (result.getMessages() == null || result.getMessages().isEmpty()) {
            logger.warn("The list of messages returned by the error response handler is empty. Falling back to default message.");
            ErrorStatusException e = new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]);
            Message defaultMessage = Message.create((String)e.getLocalizedMessage(), (ServiceException)e);
            result.setMessages(Arrays.asList(defaultMessage));
            result.setHttpStatus(Integer.valueOf(500));
        }
        if (result.getHttpStatus() == null || result.getHttpStatus() < 400) {
            result.setHttpStatus(Integer.valueOf(500));
        }
        return result;
    }

    @On(event={"APPLICATION_PREPARED", "APPLICATION_STOPPED"})
    @HandlerOrder(value=0x7FFFFFFE)
    private void autoComplete(EventContext context) {
        context.setCompleted();
    }
}

