/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.Result;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.cds.QueryAuthorizationCheckHelper;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class InstanceBasedAuthorizationPayloadHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(InstanceBasedAuthorizationPayloadHandler.class);

    @After(event={"CREATE", "UPDATE"})
    @HandlerOrder(value=-11100)
    private void checkPayloadAuthorization(EventContext context) {
        Result result;
        if (context.getUserInfo().isPrivileged()) {
            return;
        }
        CdsEntity target = context.getTarget();
        AuthorizationService authService = (AuthorizationService)context.getServiceCatalog().getService(AuthorizationService.class, "AuthorizationService$Default");
        CqnPredicate authFilter = authService.calcWhereCondition(target.getQualifiedName(), context.getEvent());
        if (authFilter == null) {
            return;
        }
        if (context.getTarget().keyElements().findAny().isEmpty()) {
            logger.debug("Restriction on entity '{}' is ignored, because it has no keys", (Object)target.getQualifiedName());
            return;
        }
        CqnPredicate keyFilter = QueryAuthorizationCheckHelper.keyFilterFromStatement(context);
        if (keyFilter == CQL.FALSE && (keyFilter = QueryAuthorizationCheckHelper.keyFilterFromResult(context, result = (Result)context.get("result"))) == CQL.FALSE) {
            logger.debug("Payload of the entity defines no key values or the key values are incomplete. Restriction is ignored.");
            return;
        }
        boolean hasAccess = QueryAuthorizationCheckHelper.checkAccessWithSelect(context, keyFilter, authFilter);
        if (!hasAccess) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.FORBIDDEN_VALUE, new Object[]{target.getQualifiedName()});
        }
    }
}

