/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.messages.Message;
import java.util.Set;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ValidationErrorHandler
implements EventHandler {
    private static final String previousMessagesKey = "cds.internal.validations.previousMessages";

    @Before
    @HandlerOrder(value=-10499)
    public void keepPreviousMessages(EventContext context) {
        Set previousMessages = context.getMessages().stream().collect(Collectors.toSet());
        context.put(previousMessagesKey, previousMessages);
    }

    @Before
    @HandlerOrder(value=11200)
    public void throwIfError(EventContext context) {
        if (context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().isCombined()) {
            Set previousMessages = (Set)context.get(previousMessagesKey);
            if (context.getMessages().stream().anyMatch(m -> !previousMessages.contains(m) && m.getSeverity().equals((Object)Message.Severity.ERROR))) {
                context.getMessages().throwIfError();
            }
        }
    }
}

