/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.handlerregistry;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;
import com.sap.cds.services.impl.handlerregistry.resolver.ArgumentResolver;
import com.sap.cds.services.impl.handlerregistry.resolver.EventContextArgumentResolver;
import com.sap.cds.services.impl.handlerregistry.resolver.PojoArgumentResolver;
import com.sap.cds.services.impl.handlerregistry.resolver.ResultReturnResolver;
import com.sap.cds.services.impl.handlerregistry.resolver.ReturnResolver;
import com.sap.cds.services.impl.handlerregistry.resolver.VoidReturnResolver;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AnnotatedHandlerMethodsFinder {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final Map<String, HandlerDescriptor> handlerDescriptors = new HashMap<String, HandlerDescriptor>();
    private ServiceName closestDefaultServiceName = null;

    public AnnotatedHandlerMethodsFinder(Class<?> clazz) {
        this.iterate(clazz);
        for (HandlerDescriptor descriptor : this.getHandlerDescriptors()) {
            if (this.closestDefaultServiceName != null) {
                descriptor.setDefaultServiceNames(this.closestDefaultServiceName.value());
                descriptor.setDefaultServiceTypes(this.closestDefaultServiceName.type());
            }
            descriptor.verifyOrThrow();
        }
    }

    public Collection<HandlerDescriptor> getHandlerDescriptors() {
        return this.handlerDescriptors.values();
    }

    private void iterate(Class<?> cls) {
        if (cls != null && cls != Object.class) {
            this.iterate(cls.getSuperclass());
            for (Class<?> interf : cls.getInterfaces()) {
                this.iterate(interf);
            }
            this.processClass(cls);
        }
    }

    private void processClass(Class<?> cls) {
        for (Method method : cls.getDeclaredMethods()) {
            HandlerOrder order;
            String methodKey = this.toMethodKey(method);
            String methodName = method.toString();
            HandlerDescriptor descriptor = this.handlerDescriptors.get(methodKey);
            Before eBefore = method.getAnnotation(Before.class);
            On eOn = method.getAnnotation(On.class);
            After eAfter = method.getAnnotation(After.class);
            if (eBefore != null || eOn != null || eAfter != null) {
                if (descriptor == null) {
                    MethodHandle methodHandle;
                    try {
                        method.setAccessible(true);
                        methodHandle = lookup.unreflect(method);
                        methodHandle = methodHandle.asSpreader(Object[].class, method.getParameterCount() + 1);
                    }
                    catch (IllegalAccessException e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.HANDLER_NOT_ACCESSIBLE, new Object[]{method.getName(), e});
                    }
                    descriptor = new HandlerDescriptor(methodName, methodHandle, method.getParameterCount());
                    for (Parameter parameter : method.getParameters()) {
                        ArgumentResolver argumentResolver = EventContextArgumentResolver.createIfApplicable(parameter.getType());
                        if (argumentResolver == null) {
                            argumentResolver = PojoArgumentResolver.createIfApplicable(parameter.getType(), parameter.getParameterizedType());
                        }
                        if (argumentResolver == null) {
                            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESOLVING_PARAMETER_TYPE_FAILED, new Object[]{parameter.getType().getName(), methodName});
                        }
                        descriptor.getArgumentResolvers().add(argumentResolver);
                    }
                    Class<?> returnType = method.getReturnType();
                    ReturnResolver returnResolver = VoidReturnResolver.createIfApplicable(returnType);
                    if (returnResolver == null) {
                        returnResolver = ResultReturnResolver.createIfApplicable(method.getGenericReturnType());
                    }
                    if (returnResolver == null) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESOLVING_RETURN_TYPE_FAILED, new Object[]{returnType.getName(), methodName});
                    }
                    descriptor.setReturnResolver(returnResolver);
                    this.handlerDescriptors.put(methodKey, descriptor);
                }
                if (eBefore != null) {
                    descriptor.setBefore(eBefore);
                }
                if (eOn != null) {
                    descriptor.setOn(eOn);
                }
                if (eAfter != null) {
                    descriptor.setAfter(eAfter);
                }
            }
            if (descriptor == null || (order = method.getAnnotation(HandlerOrder.class)) == null) continue;
            descriptor.setOrder(order.value());
        }
        ServiceName defaultServiceName = cls.getAnnotation(ServiceName.class);
        if (defaultServiceName != null) {
            this.closestDefaultServiceName = defaultServiceName;
        }
    }

    private String toMethodKey(Method m) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] p = m.getParameterTypes();
        for (int i = 0; i < p.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(p[i].getName());
        }
        sb.append(')');
        return sb.toString();
    }
}

