/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExistsSubquery;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnInSubquery;
import com.sap.cds.ql.cqn.CqnInline;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.impl.authorization.ReferenceAssociationTraverser;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ReadStatementAuthorizationModifier
implements Modifier {
    private static final Predicate IS_ACTIVE_EQ_FALSE = CQL.get((String)"IsActiveEntity").eq((Object)false);
    private static final StructuredType<?> $OUTER = CQL.to((String)"$outer");
    private final AuthorizationService authorizationService;
    private final CdsModel model;
    private final String event;
    private final CdsStructuredType parentTarget;
    private final CdsStructuredType target;

    public ReadStatementAuthorizationModifier(AuthorizationService authService, CdsReadEventContext context) {
        this(authService, context.getModel(), context.getEvent(), null, (CdsStructuredType)CqnStatementUtils.targetEntity((CqnStatement)context.getCqn(), (CdsModel)context.getModel()));
    }

    private ReadStatementAuthorizationModifier(AuthorizationService authorizationService, CdsModel model, String event, CdsStructuredType parentTarget, CdsStructuredType target) {
        this.authorizationService = Objects.requireNonNull(authorizationService);
        this.model = Objects.requireNonNull(model);
        this.event = event;
        this.target = target;
        this.parentTarget = parentTarget;
    }

    public CqnStructuredTypeRef ref(CqnStructuredTypeRef ref) {
        CqnReference.Segment targetSegment = ref.targetSegment();
        CdsEntity root = this.model.getEntity(ref.firstSegment());
        List<CqnReference.Segment> segments = ReferenceAssociationTraverser.modify((CdsStructuredType)root, (CqnReference)ref, ReferenceAssociationTraverser.NO_COMPOSITIONS, segment -> {
            if (segment.segment() != targetSegment) {
                return this.secureSegment((ResolvedSegment)segment);
            }
            return segment.segment();
        });
        return StructuredTypeRefImpl.typeRef(segments);
    }

    public CqnPredicate where(Predicate where) {
        CqnPredicate authorizationCondition = this.authorizationService.calcWhereCondition(this.target.getQualifiedName(), this.event);
        if (authorizationCondition != null) {
            return CQL.and((CqnPredicate)where, (CqnPredicate)this.authorizedOrInactive(this.target, authorizationCondition));
        }
        return where;
    }

    public CqnPredicate exists(Select<?> subQuery) {
        return CQL.exists((CqnSelect)((CqnSelect)CQL.copy(subQuery, (Modifier)this.newModifier((CdsStructuredType)CqnStatementUtils.targetEntity(subQuery, (CdsModel)this.model)))));
    }

    public CqnPredicate in(CqnInSubquery inSubquery) {
        CqnSelect subQuery = inSubquery.subquery();
        return CQL.in((CqnValue)inSubquery.value(), (CqnSelect)((CqnSelect)CQL.copy((CqnStatement)subQuery, (Modifier)this.newModifier((CdsStructuredType)CqnStatementUtils.targetEntity((CqnStatement)subQuery, (CdsModel)this.model)))));
    }

    public CqnPredicate match(CqnMatchPredicate match) {
        List<CqnReference.Segment> segments = this.copyRef((CqnReference)match.ref());
        return CQL.match((CqnStructuredTypeRef)CQL.to(segments).as((String)match.ref().alias().orElse(null)).asRef(), (CqnPredicate)match.predicate().orElse(null), (CqnMatchPredicate.Quantifier)match.quantifier());
    }

    public CqnSelectListItem expand(CqnExpand expand) {
        ReadStatementAuthorizationModifier.rejectStarAndEmptyRefs((CqnReference)expand.ref());
        List<CqnReference.Segment> segments = this.copyRef((CqnReference)expand.ref());
        CdsStructuredType expandTarget = CdsModelUtils.target((CdsStructuredType)this.target, (List)expand.ref().segments());
        Expand result = CQL.to(segments).as((String)expand.ref().alias().orElse(null)).expand((Iterable)ExpressionVisitor.copy((Collection)expand.items(), (Modifier)this.newModifier(expandTarget))).limit(expand.top(), expand.skip()).inlineCount(expand.hasInlineCount()).orderBy(expand.orderBy()).as(expand.displayName());
        if (((ExpandBuilder)expand).lazy()) {
            ((ExpandBuilder)result).lazy(true);
        }
        return result;
    }

    public CqnSelectListItem inline(CqnInline inline) {
        ReadStatementAuthorizationModifier.rejectStarAndEmptyRefs((CqnReference)inline.ref());
        List<CqnReference.Segment> segments = this.copyRef((CqnReference)inline.ref());
        CdsStructuredType inlineTarget = CdsModelUtils.target((CdsStructuredType)this.target, (List)inline.ref().segments());
        return CQL.to(segments).as((String)inline.ref().alias().orElse(null)).inline((Iterable)ExpressionVisitor.copy((Collection)inline.items(), (Modifier)this.newModifier(inlineTarget)));
    }

    public CqnValue ref(CqnElementRef ref) {
        if (!ReadStatementAuthorizationModifier.isPath(ref)) {
            return ref;
        }
        List<CqnReference.Segment> segments = "$outer".equals(ref.firstSegment()) ? ReferenceAssociationTraverser.modify(this.parentTarget, (CqnReference)ref, ReferenceAssociationTraverser.NO_COMPOSITIONS, this::secureSegment) : ReferenceAssociationTraverser.modify(this.target, (CqnReference)ref, ReferenceAssociationTraverser.NO_COMPOSITIONS, this::secureSegment);
        return CQL.get(segments).as((String)ref.alias().orElse(null));
    }

    private List<CqnReference.Segment> copyRef(CqnReference ref) {
        ReadStatementAuthorizationModifier.rejectStarAndEmptyRefs(ref);
        return ReferenceAssociationTraverser.modify(this.target, ref, ReferenceAssociationTraverser.NO_COMPOSITIONS, this::secureSegment);
    }

    private CqnReference.Segment secureSegment(ResolvedSegment current) {
        CqnPredicate authorizationCondition = this.authorizedOrInactive(current.type(), this.authorizationService.calcWhereCondition(current.type().getQualifiedName(), this.event));
        if (authorizationCondition != null) {
            CqnPredicate rewritten = this.movePathsToExistsSubquery(current, authorizationCondition);
            return CQL.refSegment((String)current.segment().id(), (CqnPredicate)CQL.and((CqnPredicate)current.segment().filter().orElse(null), (CqnPredicate)rewritten));
        }
        return current.segment();
    }

    private CqnPredicate authorizedOrInactive(CdsStructuredType target, CqnPredicate authorizationCondition) {
        if (DraftUtils.isDraftEnabled((CdsAnnotatable)target)) {
            return CQL.or((CqnPredicate)authorizationCondition, (CqnPredicate)IS_ACTIVE_EQ_FALSE);
        }
        return authorizationCondition;
    }

    private ReadStatementAuthorizationModifier newModifier(CdsStructuredType newTarget) {
        return new ReadStatementAuthorizationModifier(this.authorizationService, this.model, this.event, this.target, newTarget);
    }

    private static void rejectStarAndEmptyRefs(CqnReference ref) {
        if (ref.segments().isEmpty() || ref.firstSegment().equals("*")) {
            throw new IllegalStateException("The star expand or empty ref are not supposed to reach authorization check");
        }
    }

    private CqnPredicate movePathsToExistsSubquery(ResolvedSegment target, CqnPredicate authorizationCondition) {
        if (authorizationCondition.equals(CQL.FALSE) || authorizationCondition.asPredicate() instanceof CqnExistsSubquery) {
            return authorizationCondition;
        }
        HasRefsWithComplexPaths v = new HasRefsWithComplexPaths();
        authorizationCondition.accept((CqnVisitor)v);
        if (v.containsPaths()) {
            CqnPredicate condition = authorizationCondition;
            if (target.element() != null) {
                CqnPredicate joinCondition = (CqnPredicate)CdsModelUtils.targetKeys((CdsElement)target.element()).stream().map(k -> CQL.get((String)k).eq((Value)$OUTER.get(k))).collect(Conjunction.and());
                condition = CQL.and((CqnPredicate)joinCondition, (CqnPredicate)authorizationCondition);
            }
            return CQL.exists((CqnSelect)Select.from((String)target.type().getQualifiedName()).where(condition));
        }
        return authorizationCondition;
    }

    private static boolean isPath(CqnElementRef ref) {
        return ref.size() > 1 && !"$user".equals(ref.firstSegment());
    }

    private static class HasRefsWithComplexPaths
    implements CqnVisitor {
        private boolean hasPath = false;

        private HasRefsWithComplexPaths() {
        }

        public void visit(CqnElementRef elementRef) {
            if (!this.hasPath) {
                this.hasPath = ReadStatementAuthorizationModifier.isPath(elementRef);
            }
        }

        public boolean containsPaths() {
            return this.hasPath;
        }
    }
}

