/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.environment;

import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.info.CdsInfo;
import java.util.HashMap;
import java.util.Map;

public class EnvironmentInfo
implements CdsInfo,
CdsRuntimeAware {
    private CdsRuntime runtime;

    public void setCdsRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public String name() {
        return "environment";
    }

    public Map<String, Map<String, Object>> info(CdsInfo.Details details) {
        HashMap<String, Map<String, Object>> environment = new HashMap<String, Map<String, Object>>();
        HashMap<String, String> applicationInfo = new HashMap<String, String>();
        HashMap serviceBindings = new HashMap();
        environment.put("applicationInfo", applicationInfo);
        environment.put("serviceBindings", serviceBindings);
        ApplicationInfo info = this.runtime.getEnvironment().getApplicationInfo();
        applicationInfo.put("name", info.getName());
        applicationInfo.put("id", info.getId());
        if (details.compareTo((Enum)CdsInfo.Details.MEDIUM) >= 0) {
            applicationInfo.put("url", info.getUrl());
        }
        this.runtime.getEnvironment().getServiceBindings().forEach(binding -> {
            HashMap<String, Object> serviceBinding = new HashMap<String, Object>();
            serviceBindings.put((String)binding.getName().get(), serviceBinding);
            serviceBinding.put("name", binding.getName().get());
            serviceBinding.put("service", binding.getServiceName().get());
            if (binding.getServicePlan().isPresent()) {
                serviceBinding.put("servicePlan", binding.getServicePlan().get());
            }
            serviceBinding.put("tags", binding.getTags());
        });
        return environment;
    }
}

