/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.Service;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.impl.outbox.CqnServiceOutboxHandler;
import com.sap.cds.services.impl.outbox.InMemoryOutbox;
import com.sap.cds.services.impl.outbox.persistence.PersistentOutbox;
import com.sap.cds.services.impl.outbox.persistence.PersistentOutboxInitializationHandler;
import com.sap.cds.services.impl.outbox.persistence.collectors.TenantCache;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.outbox.OutboxUtils;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboxServiceConfiguration
implements CdsRuntimeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OutboxServiceConfiguration.class);
    private final TenantCache tenantCache = new TenantCache();

    public void services(CdsRuntimeConfigurer configurer) {
        CdsRuntime runtime = configurer.getCdsRuntime();
        CdsProperties.Outbox outboxConfig = runtime.getEnvironment().getCdsProperties().getOutbox();
        if (outboxConfig.getPersistent().isEnabled().booleanValue()) {
            if (OutboxUtils.hasOutboxModel((CdsModel)runtime.getCdsModel())) {
                CdsProperties.Outbox.OutboxServiceConfig defaultConfig;
                HashSet disabled = new HashSet();
                outboxConfig.getServices().values().forEach(config -> {
                    if (config.isEnabled().booleanValue()) {
                        configurer.service((Service)new PersistentOutbox(config.getName(), this.overwriteOrderedFlag((CdsProperties.Outbox.OutboxServiceConfig)config), runtime, this.tenantCache::getTenants));
                    } else {
                        disabled.add(config.getName());
                    }
                });
                if (runtime.getServiceCatalog().getService(OutboxService.class, "DefaultOutboxOrdered") == null && !disabled.contains("DefaultOutboxOrdered")) {
                    defaultConfig = this.overwriteOrderedFlag(new CdsProperties.Outbox.OutboxServiceConfig("DefaultOutboxOrdered"));
                    configurer.service((Service)new PersistentOutbox("DefaultOutboxOrdered", defaultConfig, runtime, this.tenantCache::getTenants));
                }
                if (runtime.getServiceCatalog().getService(OutboxService.class, "DefaultOutboxUnordered") == null && !disabled.contains("DefaultOutboxUnordered")) {
                    defaultConfig = this.overwriteOrderedFlag(new CdsProperties.Outbox.OutboxServiceConfig("DefaultOutboxUnordered"));
                    configurer.service((Service)new PersistentOutbox("DefaultOutboxUnordered", defaultConfig, runtime, this.tenantCache::getTenants));
                }
            } else if (!outboxConfig.getServices().isEmpty()) {
                logger.warn("Explicitly configured outbox services will not be available, because persistent outboxes model is not available.");
            }
        }
        if (outboxConfig.getInMemory().isEnabled().booleanValue()) {
            configurer.service((Service)new InMemoryOutbox("OutboxService$InMemory", runtime));
        }
    }

    private CdsProperties.Outbox.OutboxServiceConfig overwriteOrderedFlag(CdsProperties.Outbox.OutboxServiceConfig config) {
        if ("DefaultOutboxOrdered".equals(config.getName())) {
            config.setOrdered(true);
        } else if ("DefaultOutboxUnordered".equals(config.getName())) {
            config.setOrdered(false);
        }
        return config;
    }

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        if (configurer.getCdsRuntime().getServiceCatalog().getServices(PersistentOutbox.class).findAny().isPresent()) {
            configurer.eventHandler((Object)new PersistentOutboxInitializationHandler(this.tenantCache));
        }
        configurer.eventHandler((Object)new CqnServiceOutboxHandler());
    }

    public int order() {
        return -100;
    }
}

