/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl;

import com.sap.cds.services.ServiceExceptionUtils;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.impl.messages.SimpleLocalizedMessageProvider;
import com.sap.cds.services.impl.request.RequestContextImpl;
import com.sap.cds.services.impl.request.RequestContextSPI;
import com.sap.cds.services.impl.utils.DefaultTranslationUtils;
import com.sap.cds.services.messages.LocalizedMessageProvider;
import java.util.Locale;

public class ServiceExceptionUtilsImpl
implements ServiceExceptionUtils {
    public static LocalizedMessageProvider defaultLocalizedMessageProvider = new SimpleLocalizedMessageProvider();
    public static CdsProperties.Errors errorsProperties = new CdsProperties.Errors();

    public String getMessage(String code, Object[] args) {
        return DefaultTranslationUtils.getErrorStatusDescription(code, args).orElseGet(() -> defaultLocalizedMessageProvider.get(code, args, null));
    }

    public String getLocalizedMessage(String code, Object[] args, Locale locale, boolean errorStatusFallback) {
        Locale theLocale = locale;
        if (theLocale == null) {
            RequestContextSPI requestContext = RequestContextImpl.getCurrentInternal();
            theLocale = requestContext != null ? requestContext.getParameterInfo().getLocale() : null;
        }
        return DefaultTranslationUtils.getLocalizedMessage(defaultLocalizedMessageProvider, code, args, theLocale, errorsProperties, errorStatusFallback);
    }

    public CdsProperties.Errors getErrorsProperties() {
        return errorsProperties;
    }
}

