/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.auditlog.Access;
import com.sap.cds.services.auditlog.Attribute;
import com.sap.cds.services.impl.auditlog.PersonalDataAnalyzer;
import com.sap.cds.services.impl.auditlog.PersonalDataCaches;
import com.sap.cds.services.impl.auditlog.PersonalDataMeta;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

class PersonalDataAnalyzerAccess
extends PersonalDataAnalyzer {
    private final Map<String, Pair<CdsStructuredType, Map<String, CqnElementRef>>> accessedSensitiveElements;

    PersonalDataAnalyzerAccess(CdsEntity entity, Map<String, Pair<CdsStructuredType, Map<String, CqnElementRef>>> accessedSensitiveElements, PersonalDataCaches caches, CdsRuntime runtime) {
        super((CdsStructuredType)entity, caches, runtime);
        this.accessedSensitiveElements = Objects.requireNonNull(accessedSensitiveElements, "accessedSensitiveElements must not be null");
    }

    @Override
    boolean hasPersonalData() {
        return !this.accessedSensitiveElements.isEmpty();
    }

    List<Access> getDataAccesses() {
        final ArrayList<Access> accesses = new ArrayList<Access>();
        DataProcessor.create().action(new DataProcessor.Action(){

            public void entries(Path path, CdsElement element, CdsStructuredType currentEntity, Iterable<Map<String, Object>> dataList) {
                PersonalDataMeta meta = PersonalDataAnalyzerAccess.this.getMeta(currentEntity);
                if (meta != null && PersonalDataAnalyzerAccess.this.personalData.getLogRead().isEnabled().booleanValue() && PersonalDataAnalyzerAccess.this.accessedSensitiveElements.containsKey(currentEntity.getQualifiedName())) {
                    Set<String> accessedList = ((Map)PersonalDataAnalyzerAccess.this.accessedSensitiveElements.get(currentEntity.getQualifiedName()).getRight()).values().stream().map(CqnReference::lastSegment).collect(Collectors.toSet());
                    List<Attribute> attributes = PersonalDataAnalyzerAccess.this.createAttributes(accessedList, meta);
                    for (Map<String, Object> dataRow : dataList) {
                        if (attributes.isEmpty()) continue;
                        Access access = Access.create();
                        access.setDataObject(PersonalDataAnalyzerAccess.this.createDataObject(dataRow, meta));
                        access.setAttributes(attributes);
                        access.setDataSubject(PersonalDataAnalyzerAccess.this.createDataSubject(dataRow, meta));
                        accesses.add(access);
                    }
                }
            }
        }).process(this.data, this.entity);
        return accesses;
    }

    private List<Attribute> createAttributes(Collection<String> accessedElements, PersonalDataMeta meta) {
        Set<String> sensitiveDataNames = meta.getSensitiveDataNames();
        return accessedElements.stream().filter(sensitiveDataNames::contains).map(element -> {
            Attribute attribute = Attribute.create();
            attribute.setName(element);
            return attribute;
        }).toList();
    }
}

