/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messages;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.impl.messages.MessageImpl;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageLookup;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MessagesImpl
implements Messages {
    private ConcurrentLinkedQueue<Message> messages = new ConcurrentLinkedQueue();
    private final CdsRuntime runtime;
    private final Locale locale;

    public MessagesImpl(CdsRuntime runtime, Locale locale) {
        this.runtime = runtime;
        this.locale = locale;
    }

    public Message info(String messageOrKey, Object ... args) {
        Message message = this.createMessage(Message.Severity.INFO, messageOrKey, args);
        this.messages.add(message);
        return message;
    }

    public Message success(String messageOrKey, Object ... args) {
        Message message = this.createMessage(Message.Severity.SUCCESS, messageOrKey, args);
        this.messages.add(message);
        return message;
    }

    public Message warn(String messageOrKey, Object ... args) {
        Message message = this.createMessage(Message.Severity.WARNING, messageOrKey, args);
        this.messages.add(message);
        return message;
    }

    public Message error(String messageOrKey, Object ... args) {
        Message message = this.createMessage(Message.Severity.ERROR, messageOrKey, args);
        this.messages.add(message);
        return message;
    }

    private Message createMessage(Message.Severity severity, String messageOrKey, Object[] args) {
        return new MessageImpl(severity, this.runtime.getLocalizedMessage(messageOrKey, args, this.locale), MessageLookup.create((String)messageOrKey, (Object[])args));
    }

    public void throwIfError() throws ServiceException {
        this.messages.stream().filter(m -> m.getSeverity().equals((Object)Message.Severity.ERROR)).findFirst().ifPresent(error -> {
            this.messages.remove(error);
            ErrorStatus status = new ErrorStatus(){
                final /* synthetic */ Message val$error;
                {
                    this.val$error = message;
                }

                public String getCodeString() {
                    return this.val$error.getCode() != null ? this.val$error.getCode() : String.valueOf(this.getHttpStatus());
                }

                public int getHttpStatus() {
                    return ErrorStatuses.BAD_REQUEST.getHttpStatus();
                }
            };
            MessageLookup messageLookup = error.getMessageLookup();
            throw new ServiceException(status, messageLookup.getMessageOrKey(), messageLookup.getArgs()).messageTarget(error.getTarget()).additionalTargets(error.getAdditionalTargets()).longTextUrl(error.getLongTextUrl()).transition(error.isTransition());
        });
    }

    public Stream<Message> stream() {
        return this.messages.stream();
    }

    public List<Message> removeIf(Predicate<Message> filter) {
        ArrayList<Message> removed = new ArrayList<Message>();
        Iterator<Message> iterator = this.messages.iterator();
        while (iterator.hasNext()) {
            Message message = iterator.next();
            if (!filter.test(message)) continue;
            iterator.remove();
            removed.add(message);
        }
        return removed;
    }
}

