/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.impl.outbox.OutboxedServiceProxyUtils;
import com.sap.cds.services.outbox.OutboxMessage;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cds.services.utils.outbox.OutboxUtils;
import java.time.Instant;

public abstract class AbstractOutboxService
extends ServiceDelegator
implements OutboxService {
    protected final CdsRuntime runtime;

    protected AbstractOutboxService(String name, CdsRuntime runtime) {
        super(name);
        this.runtime = runtime;
    }

    public void submit(String outboxEvent, OutboxMessage message) {
        OutboxMessageEventContext context = OutboxMessageEventContext.create((String)outboxEvent);
        context.setMessage(message);
        this.emit((EventContext)context);
    }

    public <S extends Service> S outboxed(S service) {
        return OutboxedServiceProxyUtils.outboxed(this, service, this.runtime);
    }

    public <A extends Service> A outboxed(Service service, Class<A> asyncInterface) {
        return OutboxedServiceProxyUtils.outboxed(this, service, asyncInterface, this.runtime);
    }

    @On
    @HandlerOrder(value=-9900)
    private void storeOutboxMessage(OutboxMessageEventContext context) {
        if (Boolean.FALSE.equals(context.getIsInbound())) {
            if (context.getTimestamp() == null) {
                context.setTimestamp(Instant.now());
            }
            RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)context.getCdsRuntime());
            OutboxUtils.storeRequestContext((RequestContext)requestContext, (OutboxMessage)context.getMessage());
            this.submit(context);
            context.setCompleted();
        }
    }

    @On
    @HandlerOrder(value=11000)
    private void publishOutboxMessage(OutboxMessageEventContext context) {
        Service service = context.getServiceCatalog().getService(context.getEvent());
        if (service == null) {
            return;
        }
        RequestContextRunner runner = context.getCdsRuntime().requestContext();
        OutboxUtils.restoreRequestContext((RequestContextRunner)runner, (OutboxMessage)context.getMessage());
        runner.run(req -> OutboxService.unboxed((Service)service).emit(OutboxUtils.toEventContext((OutboxMessageEventContext)context)));
        context.setCompleted();
    }

    protected abstract void submit(OutboxMessageEventContext var1);
}

