package com.sap.cds.services.impl.draft.messages;

import static com.sap.cds.services.impl.draft.messages.DraftMessageUtils.MESSAGES_ELEMENT;
import static com.sap.cds.services.impl.draft.messages.DraftMessagesWriteHandler.DRAFT_MESSAGES_SKIP_HINT;

import java.util.List;
import java.util.Map;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.draft.DraftPrepareEventContext;
import com.sap.cds.services.draft.DraftSaveEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.draft.Drafts;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.utils.OrderConstants;

@ServiceName(value = "*", type = DraftService.class)
class DraftMessagesActionHandler implements EventHandler {

	@On
	@HandlerOrder(OrderConstants.On.FEATURE)
	void draftActivate(DraftSaveEventContext context) {
		ServiceException exception = null;
		try {
			context.proceed();
		} catch (ServiceException e) {
			exception = e;
			throw e;
		} finally {
			List<DraftMessage> draftMessages = DraftMessageUtils.toDraftMessages(exception, context.getMessages());
			context.getChangeSetContext().register(new ChangeSetListener() {

				@Override
				public void afterClose(boolean completed) {
					if (!completed) { // messages are stored with the draft, which doesn't exist anymore if the activation succeeded
						context.getCdsRuntime().requestContext().clearMessages().run(requestContext -> {
							CqnUpdate update = Update.entity(context.getCqn().ref()).where(context.getCqn().where().orElse(CQL.TRUE))
									.entry(Map.of(Drafts.DRAFT_ADMINISTRATIVE_DATA, Map.of(MESSAGES_ELEMENT, draftMessages)))
									.hint(DRAFT_MESSAGES_SKIP_HINT, true);
							context.getService().patchDraft(update);
						});
					}
				}

			});
		}
	}

	@On
	@HandlerOrder(OrderConstants.On.FEATURE)
	void draftPrepare(DraftPrepareEventContext context) {
		String select = context.getParameterInfo().getQueryParameter("$select");
		if (select == null || !select.contains(MESSAGES_ELEMENT)) {
			return; // no messages requested
		}

		// simulate validation
		context.getCdsRuntime().requestContext().clearMessages().run(requestContext -> {
			context.getCdsRuntime().changeSetContext().run(changeSetContext -> {
				try {
					context.getService().saveDraft(context.getCqn());
				} catch (ServiceException e) {
					// ignore
				} finally {
					changeSetContext.markForCancel();
				}
			});
		});
	}

}
