package com.sap.cds.services.impl.draft.messages;

import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class DraftMessagesConfiguration implements CdsRuntimeConfiguration {

	@Override
	public void eventHandlers(CdsRuntimeConfigurer configurer) {
		boolean hasDraftServices = configurer.getCdsRuntime().getServiceCatalog()
			.getServices(DraftService.class).findFirst().isPresent();

		if (hasDraftServices && DraftMessageUtils.isDraftMessagesEnabled(configurer.getCdsRuntime().getCdsModel())) {
			configurer.eventHandler(new DraftMessagesReadHandler());
			configurer.eventHandler(new DraftMessagesWriteHandler());
			configurer.eventHandler(new DraftMessagesActionHandler());
		}
	}

}
