/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;

/**
 * Handles all types of {@link CqnStatement} and {@link CqnStructuredTypeRef} based arguments in handler methods
 */
public class CqnStatementArgumentResolver implements ArgumentResolver {

	public static CqnStatementArgumentResolver createIfApplicable(Class<?> type) {
		if (CqnStatement.class.isAssignableFrom(type)) {
			return new CqnStatementArgumentResolver(type, false);
		} else if (CqnStructuredTypeRef.class.equals(type)) {
			return new CqnStatementArgumentResolver(CqnStatement.class, true);
		}
		return null;
	}

	private final Class<? extends CqnStatement> cqnStatementType;
	private final boolean ref;

	@SuppressWarnings("unchecked")
	private CqnStatementArgumentResolver(Class<?> type, boolean ref) {
		this.cqnStatementType = (Class<? extends CqnStatement>) type;
		this.ref = ref;
	}

	@Override
	public Object resolve(EventContext context) {
		CqnStatement cqn = cqnStatementType.cast(context.get("cqn"));
		return cqn != null && ref ? (!cqn.isSelect() || cqn.asSelect().from().isRef() ? cqn.ref() : null) : cqn;
	}

	@Override
	public void verifyOrThrow(HandlerDescriptor descriptor) {
		// not yet validated
	}

}
