/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.messages;

import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.utils.StringUtils;

/**
 * Implementation of a {@link LocalizedMessageProvider} based on SLF4's message format.
 * This implementation is only capable of building message texts and never considers the locale.
 * It is considered to be used as a fallback in case no resource bundle or other mechanism is available.
 */
public class SimpleLocalizedMessageProvider implements LocalizedMessageProvider {

	private static final Logger logger = LoggerFactory.getLogger(SimpleLocalizedMessageProvider.class);

	@Override
	public String get(String messageOrKey, Object[] args, Locale locale) {
		try {
			return MessageFormatter.arrayFormat(messageOrKey, args).getMessage();
		} catch (Exception e) {  // NOSONAR
			// be tolerant - we don't want to break the request due to wrong message resolution
			logger.warn("Invalid message format '{}' or incompatible arguments {}", messageOrKey, StringUtils.toStringSafely(args), e);
			return messageOrKey;
		}
	}


}
