/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.services.utils.lib.mtx.impl.ModelProviderAccess;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;

public class DynamicModelProviderConfiguration implements CdsRuntimeConfiguration {

	private static final Logger logger = LoggerFactory.getLogger(DynamicModelProviderConfiguration.class);

	@Override
	public void providers(CdsRuntimeConfigurer configurer) {
		DynamicModelUtils utils = new DynamicModelUtils(configurer.getCdsRuntime());
		if (utils.isModelProviderEnabled()) {
			logger.info("Loading DynamicModelProvider");
			configurer.provider(new DynamicModelProvider(configurer.getCdsRuntime()));

			// TODO sync with other destinations
			HttpDestination destination = utils.createSidecarDestination(ModelProviderAccess.MODEL_PROVIDER_DESTINATION, utils.getModelProviderUrl());
			DefaultDestinationLoader destinationLoader = new DefaultDestinationLoader();
			destinationLoader.registerDestination(destination);
			DestinationAccessor.prependDestinationLoader(destinationLoader);
		}
	}

}
