/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.utils;

import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

public class ValidatorErrorUtils {

	private ValidatorErrorUtils() {
		// empty
	}

	public static void handleValidationError(EventContext context, Path path, CdsElement element,
			CdsErrorStatuses status, Object... args) {
		handleValidationError(context, false, path, element, status, args);
	}

	public static void handleValidationError(EventContext context, boolean forceException, Path path,
			CdsElement element, CdsErrorStatuses status, Object... args) {
		// validations on action/function parameters are considered transition messages
		boolean isTransition = CdsModelUtils.isInternalOperationType(element.getDeclaringType().as(CdsDefinition.class));
		if (!forceException && context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().isCombined()) {
			context.getMessages().error(status.getCodeString(), args)
					.code(status.getCodeString())
					.target(path, element)
					.transition(isTransition);
		} else {
			throw new ErrorStatusException(status, args)
					.messageTarget(path, element)
					.transition(isTransition);
		}
	}

}
