/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.impl.parser.ExprParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.ql.impl.PathImpl;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.ValidatorExecutor;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageTarget;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ConstraintAssertionHandler
implements EventHandler {
    private static final String CONSTRAINT_PREFIX = "@constraint_";
    private static final String MANDATORY_PREFIX = "@mandatory_";
    private static final String INAPPLICABLE_PREFIX = "@inapplicable_";
    private static final String PARAMETER_PREFIX = "@parameter_";
    private static final Value<String> EMPTY = CQL.constant((Object)"");
    private final PersistenceService db;
    private final TenantAwareCache<Map<CdsStructuredType, Map<String, Constraint>>, CdsModel> constraintCache;

    ConstraintAssertionHandler(CdsRuntime runtime) {
        this.db = (PersistenceService)runtime.getServiceCatalog().getService(PersistenceService.class, "PersistenceService$Default");
        this.constraintCache = TenantAwareCache.create(ConcurrentHashMap::new, (CdsRuntime)runtime);
    }

    @After(event={"CREATE", "UPDATE", "UPSERT", "DRAFT_NEW", "DRAFT_PATCH"})
    @HandlerOrder(value=10500)
    public void assertConstraints(Result result, CqnStatement cqn, EventContext context) {
        if (ValidatorExecutor.isValidationEvent(context, true)) {
            this.assertContraintsInternal(result, context);
            if (!context.getEvent().startsWith("DRAFT_")) {
                context.put("cds.internal.validations.throwIfErrorInAfter", (Object)true);
            }
        }
    }

    private void assertContraintsInternal(Result result, final EventContext context) {
        Map constraintsPerEntity = (Map)this.constraintCache.findOrCreate();
        HashMap<CdsStructuredType, List> keysPerEntity = new HashMap<CdsStructuredType, List>();
        CdsStructuredType resultType = result.rowType() != null ? result.rowType() : context.getTarget();
        DataProcessor.create().bulkAction((type, entries) -> {
            Map constraints = constraintsPerEntity.computeIfAbsent(type, ConstraintAssertionHandler::collectConstraints);
            if (!constraints.isEmpty()) {
                List keyValues = keysPerEntity.computeIfAbsent((CdsStructuredType)type, t -> new ArrayList());
                Set keyNames = CdsModelUtils.concreteKeyNames((CdsStructuredType)type);
                entries.forEach(entry -> ConstraintAssertionHandler.addKeysTo(keyNames, entry, keyValues));
            }
        }).process((Iterable)result, resultType);
        if (keysPerEntity.isEmpty()) {
            return;
        }
        final HashMap erroneousConstraintsPerEntity = new HashMap(keysPerEntity.size());
        keysPerEntity.forEach((entity, keyValues) -> {
            if (keyValues.isEmpty()) {
                return;
            }
            Map constraints = (Map)constraintsPerEntity.get(entity);
            ArrayList selectables = new ArrayList(constraints.size());
            constraints.values().forEach(c -> {
                selectables.add(c.slv);
                selectables.addAll(c.dynamicParameters);
            });
            ArrayList keyElements = new ArrayList(((Map)keyValues.get(0)).keySet());
            keyElements.forEach(keyElement -> selectables.add(CQL.get((String)keyElement)));
            Select query = Select.from((CdsEntity)((CdsEntity)entity.as(CdsEntity.class))).columns(selectables).where((CqnPredicate)CQL.in(keyElements, (Collection)keyValues));
            Result validationResult = this.db.run((CqnSelect)query, new Object[0]);
            validationResult.forEach(row -> {
                HashMap keys = new HashMap(keyElements.size());
                ArrayList<Constraint> erroneousConstraints = new ArrayList<Constraint>(constraints.size());
                row.forEach((k, v) -> {
                    if (k.startsWith(CONSTRAINT_PREFIX) && Boolean.TRUE.equals(v)) {
                        erroneousConstraints.add((Constraint)constraints.get(k.substring(CONSTRAINT_PREFIX.length())));
                    } else if (keyElements.contains(k)) {
                        keys.put(k, v);
                    }
                });
                if (!erroneousConstraints.isEmpty()) {
                    erroneousConstraintsPerEntity.computeIfAbsent(entity, e -> new HashMap(keyValues.size())).put(keys, new ViolatedConstraints((List<Constraint>)erroneousConstraints, (Row)row));
                }
            });
        });
        if (erroneousConstraintsPerEntity.isEmpty()) {
            return;
        }
        DataProcessor.create().action(new DataProcessor.Action(){

            public void entries(Path path, CdsElement element, CdsStructuredType type, Iterable<Map<String, Object>> entries) {
                Map erroneousConstraints = (Map)erroneousConstraintsPerEntity.get(type);
                if (erroneousConstraints == null) {
                    return;
                }
                Set keyNames = CdsModelUtils.concreteKeyNames((CdsStructuredType)type);
                entries.forEach(entry -> {
                    Map<String, Object> keyValues = keyNames.stream().collect(Collectors.toMap(keyName -> keyName, entry::get));
                    ViolatedConstraints constraints = (ViolatedConstraints)erroneousConstraints.get(keyValues);
                    if (constraints != null) {
                        Path enhancedPath = ((PathImpl)path).append(element, type, entry);
                        constraints.erroneous.forEach(constraint -> {
                            Set targetPaths = constraint.targets.stream().map(s -> s.path()).collect(Collectors.toSet());
                            if (!context.getEvent().startsWith("DRAFT_") || targetPaths.stream().anyMatch(p -> DataUtils.containsKey((Map)entry, (String)p))) {
                                Object[] effectiveParameters;
                                if (constraint.parameters.length == 0 && !constraint.dynamicParameters.isEmpty()) {
                                    effectiveParameters = new Object[constraint.dynamicParameters.size()];
                                    for (int i = 0; i < effectiveParameters.length; ++i) {
                                        effectiveParameters[i] = constraints.row.get((Object)(ConstraintAssertionHandler.PARAMETER_PREFIX + constraint.name + "_" + i));
                                    }
                                } else {
                                    effectiveParameters = constraint.parameters;
                                }
                                ConstraintAssertionHandler.handleError(context.getMessages(), constraint, effectiveParameters, enhancedPath);
                            }
                        });
                    }
                });
            }
        }).process((Iterable)result, resultType);
    }

    private static Map<String, Constraint> collectConstraints(CdsStructuredType type) {
        HashMap<String, Constraint> constraints = new HashMap<String, Constraint>();
        constraints.putAll(ConstraintAssertionHandler.collectAssertConstraintAnnotations(type.annotations(), null, type.getName()));
        type.elements().forEach(e -> {
            constraints.putAll(ConstraintAssertionHandler.collectAssertConstraintAnnotations(e.annotations(), e, type.getName()));
            constraints.putAll(ConstraintAssertionHandler.collectMandatoryAnnotations(e, type));
            constraints.putAll(ConstraintAssertionHandler.collectInapplicableAnnotations(e, type));
        });
        return constraints.isEmpty() ? Map.of() : Collections.unmodifiableMap(constraints);
    }

    private static Map<String, Constraint> collectAssertConstraintAnnotations(Stream<CdsAnnotation<?>> annotations, CdsElement annotatedElement, String entityName) {
        HashMap<String, Constraint> constraints = new HashMap<String, Constraint>();
        annotations.filter(a -> a.getName().startsWith("assert.constraint.")).forEach(a -> {
            String[] segments = a.getName().substring(18).split("\\.");
            if (segments.length < 2) {
                if (annotatedElement == null) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_ANNOTATION_ENTITY, new Object[]{CdsAnnotations.ASSERT_CONSTRAINT, entityName});
                }
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_ANNOTATION, new Object[]{CdsAnnotations.ASSERT_CONSTRAINT, annotatedElement.getName(), entityName});
            }
            Constraint constraint = constraints.computeIfAbsent(segments[0], name -> new Constraint((String)name, annotatedElement));
            switch (segments[1]) {
                case "condition": {
                    constraint.setCondition(new ExprParser().parsePredicate(((CqnValue)a.getValue()).tokens()));
                    break;
                }
                case "message": {
                    constraint.setMessage((String)a.getValue());
                    break;
                }
                case "targets": {
                    constraint.setTargets((List)a.getValue());
                    break;
                }
                case "parameters": {
                    constraint.setDynamicParameters((List)a.getValue());
                }
            }
        });
        return constraints;
    }

    private static Map<String, Constraint> collectInapplicableAnnotations(CdsElement e, CdsStructuredType type) {
        if (CdsAnnotations.INAPPLICABLE.isExpression((CdsAnnotatable)e)) {
            CdsSimpleType simple;
            String constraintName = INAPPLICABLE_PREFIX + e.getName();
            Constraint c = new Constraint(constraintName, e);
            c.setMessage(CdsErrorStatuses.VALUE_NOT_APPLICABLE, e.getName(), type.getQualifiedName());
            Predicate isNotNull = CQL.get((String)e.getName()).isNotNull();
            CdsType cdsType = e.getType();
            if (cdsType instanceof CdsSimpleType && String.class.isAssignableFrom((simple = (CdsSimpleType)cdsType).getJavaType())) {
                isNotNull = isNotNull.or((CqnPredicate)CQL.get((String)e.getName()).trim().ne(EMPTY), new CqnPredicate[0]);
            }
            c.setCondition((CqnPredicate)isNotNull.and(CdsAnnotations.INAPPLICABLE.asPredicate((CdsAnnotatable)e), new CqnPredicate[0]).not());
            return Map.of(constraintName, c);
        }
        return Map.of();
    }

    private static Map<String, Constraint> collectMandatoryAnnotations(CdsElement e, CdsStructuredType type) {
        if (CdsAnnotations.MANDATORY.isExpression((CdsAnnotatable)e)) {
            CdsSimpleType simple;
            String constraintName = MANDATORY_PREFIX + e.getName();
            Constraint c = new Constraint(constraintName, e);
            c.setMessage(CdsErrorStatuses.VALUE_REQUIRED, e.getName(), type.getQualifiedName());
            Predicate isNull = CQL.get((String)e.getName()).isNull();
            CdsType cdsType = e.getType();
            if (cdsType instanceof CdsSimpleType && String.class.isAssignableFrom((simple = (CdsSimpleType)cdsType).getJavaType())) {
                isNull = isNull.or((CqnPredicate)CQL.get((String)e.getName()).trim().eq(EMPTY), new CqnPredicate[0]);
            }
            c.setCondition((CqnPredicate)isNull.and(CdsAnnotations.MANDATORY.asPredicate((CdsAnnotatable)e), new CqnPredicate[0]).not());
            return Map.of(constraintName, c);
        }
        return Map.of();
    }

    static void addKeysTo(Set<String> keyNames, Map<String, Object> entry, List<Map<String, Object>> keyValues) {
        HashMap<String, Object> keys = new HashMap<String, Object>(keyNames.size());
        for (String key : keyNames) {
            if (!entry.containsKey(key)) continue;
            keys.put(key, entry.get(key));
        }
        if (keys.size() == keyNames.size()) {
            keyValues.add(keys);
        }
    }

    private static void handleError(Messages messages, Constraint c, Object[] effectiveParameters, Path path) {
        Message message = messages.error(c.message, effectiveParameters);
        if (c.code != null) {
            message.code(c.code);
        }
        if (!c.targets.isEmpty()) {
            List targets = c.targets.stream().map(t -> MessageTarget.create((Path)path, (CdsElement)CdsModelUtils.element((CdsStructuredType)path.target().type(), (CqnElementRef)t))).collect(Collectors.toList());
            message.target((MessageTarget)targets.remove(0));
            if (!targets.isEmpty()) {
                message.additionalTargets(targets);
            }
        }
    }

    private static class Constraint {
        private final String name;
        private CqnSelectListValue slv;
        private String message;
        private String code;
        private List<CqnElementRef> targets = List.of();
        private Object[] parameters;
        private List<CqnSelectListValue> dynamicParameters = List.of();

        public Constraint(String name, CdsElement element) {
            this.name = name;
            if (element != null) {
                this.setTargets(List.of(CQL.get((String)element.getName())));
            }
            this.setMessage(CdsErrorStatuses.CONSTRAINT_VIOLATED, name);
        }

        public void setCondition(CqnPredicate predicate) {
            this.slv = CQL.not((CqnPredicate)predicate).as(ConstraintAssertionHandler.CONSTRAINT_PREFIX + this.name);
        }

        public void setMessage(String message) {
            this.message = message;
            this.code = null;
            this.parameters = new Object[0];
        }

        public void setMessage(CdsErrorStatuses errorStatus, Object ... parameters) {
            this.message = errorStatus.getCodeString();
            this.code = errorStatus.getCodeString();
            this.parameters = parameters;
        }

        public void setTargets(List<CqnElementRef> targets) {
            this.targets = targets;
        }

        public void setDynamicParameters(List<Value<?>> parameters) {
            this.dynamicParameters = new ArrayList<CqnSelectListValue>(parameters.size());
            for (int i = 0; i < parameters.size(); ++i) {
                this.dynamicParameters.add(parameters.get(i).as(ConstraintAssertionHandler.PARAMETER_PREFIX + this.name + "_" + i));
            }
        }
    }

    private record ViolatedConstraints(List<Constraint> erroneous, Row row) {
    }
}

