/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

public class ValidatorErrorUtils {
    private ValidatorErrorUtils() {
    }

    public static void handleValidationError(EventContext context, Path path, CdsElement element, CdsErrorStatuses status, Object ... args) {
        ValidatorErrorUtils.handleValidationError(context, false, path, element, status, args);
    }

    public static void handleValidationError(EventContext context, boolean forceException, Path path, CdsElement element, CdsErrorStatuses status, Object ... args) {
        boolean isTransition = CdsModelUtils.isInternalOperationType(element.getDeclaringType().as(CdsDefinition.class));
        if (forceException || !context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().isCombined()) {
            throw new ErrorStatusException((ErrorStatus)status, args).messageTarget(path, element).transition(isTransition);
        }
        context.getMessages().error(status.getCodeString(), args).code(status.getCodeString()).target(path, element).transition(isTransition);
    }
}

