/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.impl.auditlog.PersonalDataCaches;
import com.sap.cds.services.impl.auditlog.PersonalDataMeta;
import com.sap.cds.services.impl.auditlog.PersonalDataUtils;
import com.sap.cds.services.impl.utils.TargetAwareCqnModifier;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

class PersonalDataModifier
extends TargetAwareCqnModifier {
    private final List<PersonalDataModifier> children = new LinkedList<PersonalDataModifier>();
    private boolean innerCqn;
    private final boolean addPersonalData;
    private final PersonalDataCaches caches;
    private final boolean isDraftShadowEntity;
    private final Map<String, Pair<CdsStructuredType, Map<String, CqnElementRef>>> sensitiveElements = new HashMap<String, Pair<CdsStructuredType, Map<String, CqnElementRef>>>();

    PersonalDataModifier(CdsEntity target, boolean addPersonalData, PersonalDataCaches caches) {
        this(target, false, addPersonalData, caches);
    }

    private PersonalDataModifier(CdsEntity target, boolean innerCqn, boolean addPersonalData, PersonalDataCaches caches) {
        super(Objects.requireNonNull(target, "target must not null"));
        this.innerCqn = innerCqn;
        this.addPersonalData = addPersonalData;
        this.caches = Objects.requireNonNull(caches, "caches must not null");
        this.isDraftShadowEntity = target.getQualifiedName().endsWith("_drafts");
    }

    public CqnStructuredTypeRef ref(CqnStructuredTypeRef ref) {
        this.innerCqn = true;
        return ref;
    }

    @Override
    protected TargetAwareCqnModifier create(CdsEntity target) {
        PersonalDataModifier result = new PersonalDataModifier(target, this.innerCqn, this.addPersonalData, this.caches);
        this.children.add(result);
        return result;
    }

    public List<CqnSelectListItem> selectAll() {
        if (!this.isDraftShadowEntity) {
            this.getTarget().elements().filter(element -> element.getType().isSimple() || element.getType().isArrayed()).forEach(element -> this.addIfSensitive((CdsElement)element, (CqnElementRef)CQL.get((String)element.getName())));
        }
        return super.selectAll();
    }

    public CqnValue ref(CqnElementRef ref) {
        if (this.innerCqn && !this.isDraftShadowEntity) {
            CdsModelUtils.findElement((CdsStructuredType)this.getTarget(), (CqnElementRef)ref).ifPresent(element -> this.addIfSensitive((CdsElement)element, ref));
        }
        return ref;
    }

    private void addIfSensitive(CdsElement element, CqnElementRef ref) {
        if (CdsAnnotations.PERSONALDATA_POTENTIALLYSENSITIVE.isTrue((CdsAnnotatable)element) || CdsAnnotations.PERSONALDATA_POTENTIALLYPERSONAL.isTrue((CdsAnnotatable)element) && this.addPersonalData) {
            CdsStructuredType def = (CdsStructuredType)element.getDeclaringType();
            String structureKey = def.getQualifiedName();
            String elementKey = ref.path();
            if (this.sensitiveElements.containsKey(structureKey)) {
                Map refs = (Map)this.sensitiveElements.get(structureKey).getRight();
                refs.putIfAbsent(elementKey, ref);
            } else {
                this.sensitiveElements.put(structureKey, (Pair<CdsStructuredType, Map<String, CqnElementRef>>)Pair.of((Object)def, new HashMap<String, CqnElementRef>(Map.of(elementKey, ref))));
            }
        }
    }

    public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
        if (this.innerCqn) {
            this.sensitiveElements.forEach((key, value) -> {
                PersonalDataMeta pdMeta = this.getMeta((CdsStructuredType)value.getLeft());
                Set<CqnSelectListValue> elements = pdMeta.getKeyNames().stream().map(str -> CQL.get((String)str).as(PersonalDataUtils.getKeyAlias(str))).collect(Collectors.toSet());
                elements.addAll(this.getUtils((CdsStructuredType)value.getLeft()).resolveDataSubjectId());
                if (((Map)value.getRight()).values().stream().anyMatch(r -> r.size() > 1)) {
                    boolean marked = false;
                    for (CqnElementRef r2 : ((Map)value.getRight()).values()) {
                        if (r2.size() == 1 && !marked) {
                            items.addAll(elements);
                            marked = true;
                            continue;
                        }
                        items.add((CqnSelectListItem)this.expandPath(r2, elements));
                    }
                } else {
                    items.addAll(elements);
                }
            });
            this.innerCqn = false;
        }
        return super.items(items);
    }

    private Expand<?> expandPath(CqnElementRef ref, Set<CqnSelectListValue> elements) {
        ListIterator iterator = ref.segments().listIterator(ref.size() - 1);
        Expand expand = CQL.to((String)((CqnReference.Segment)iterator.previous()).id()).expand(elements);
        while (iterator.hasPrevious()) {
            CqnReference.Segment s = (CqnReference.Segment)iterator.previous();
            expand = CQL.to((String)s.id()).expand(new Selectable[]{expand});
        }
        return expand;
    }

    Map<String, Pair<CdsStructuredType, Map<String, CqnElementRef>>> getSensitiveElements() {
        HashMap<String, Pair<CdsStructuredType, Map<String, CqnElementRef>>> result = new HashMap<String, Pair<CdsStructuredType, Map<String, CqnElementRef>>>(this.sensitiveElements);
        this.children.forEach(child -> {
            Map<String, Pair<CdsStructuredType, Map<String, CqnElementRef>>> sensitiveElementsChild = child.getSensitiveElements();
            sensitiveElementsChild.forEach((key, value) -> {
                if (result.containsKey(key)) {
                    ((Map)value.getRight()).forEach((s, cqnElementRef) -> ((Map)((Pair)result.get(key)).getRight()).computeIfAbsent(s, v -> cqnElementRef));
                } else {
                    result.put((String)key, (Pair<CdsStructuredType, Map<String, CqnElementRef>>)value);
                }
            });
        });
        return result;
    }

    private PersonalDataUtils getUtils(CdsStructuredType entity) {
        return this.caches.getUtils(entity);
    }

    private PersonalDataMeta getMeta(CdsStructuredType entity) {
        return this.caches.getMeta(entity);
    }
}

