/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messages;

import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageLookup;
import com.sap.cds.services.messages.MessageTarget;
import java.util.List;
import java.util.Objects;

public class MessageImpl
implements Message {
    private final Message.Severity severity;
    private final String message;
    private final MessageLookup messageLookup;
    private String code;
    private String longTextUrl;
    private MessageTarget target;
    private List<MessageTarget> additionalTargets = List.of();
    private boolean isTransition;

    public MessageImpl(Message.Severity severity, String message) {
        this(severity, message, MessageLookup.create((String)message, null));
    }

    public MessageImpl(Message.Severity severity, String message, MessageLookup messageLookup) {
        this.severity = Objects.requireNonNull(severity, "severity must not be null");
        this.message = Objects.requireNonNull(message, "message must not be null");
        this.messageLookup = Objects.requireNonNull(messageLookup, "messageLookup must not be null");
    }

    public Message.Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public MessageLookup getMessageLookup() {
        return this.messageLookup;
    }

    public String getCode() {
        return this.code;
    }

    public MessageTarget getTarget() {
        return this.target;
    }

    public List<MessageTarget> getAdditionalTargets() {
        return this.additionalTargets;
    }

    public String getLongTextUrl() {
        return this.longTextUrl;
    }

    public boolean isTransition() {
        return this.isTransition;
    }

    public Message longTextUrl(String longTextUrl) {
        this.longTextUrl = longTextUrl;
        return this;
    }

    public Message code(String code) {
        this.code = code;
        return this;
    }

    public Message transition(boolean isTransition) {
        this.isTransition = isTransition;
        return this;
    }

    public Message target(MessageTarget target) {
        this.target = target;
        return this;
    }

    public Message additionalTargets(List<MessageTarget> additionalTargets) {
        this.additionalTargets = additionalTargets;
        return this;
    }
}

