/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.composite;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.impl.composite.CompositeService;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingCompositeService
extends CompositeService
implements MessagingService {
    private static final Logger logger = LoggerFactory.getLogger(MessagingCompositeService.class);

    public MessagingCompositeService(String name, List<CdsProperties.Composite.CompositeServiceConfig.Route> routes, CdsRuntime runtime) {
        super(MessagingCompositeService.toCompositeConfig(name, routes), runtime);
    }

    public void emit(String topic, Map<String, Object> message) {
        this.getDestinationServiceAndLog(topic).emit(topic, message);
    }

    public void emit(String topic, Map<String, Object> data, Map<String, Object> headers) {
        this.getDestinationServiceAndLog(topic).emit(topic, data, headers);
    }

    private MessagingService getDestinationServiceAndLog(String topic) {
        MessagingService destinationService = (MessagingService)this.getDestinationService(topic);
        logger.debug("Emitting the event '{}' on service '{}'", (Object)topic, (Object)destinationService.getName());
        return destinationService;
    }

    private static CdsProperties.Composite.CompositeServiceConfig toCompositeConfig(String name, List<CdsProperties.Composite.CompositeServiceConfig.Route> routes) {
        CdsProperties.Composite.CompositeServiceConfig result = new CdsProperties.Composite.CompositeServiceConfig();
        result.setName(name);
        result.setRoutes(routes);
        return result;
    }
}

