/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox;

import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Statement;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.Upsert;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.Service;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.outbox.OutboxMessage;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.outbox.OutboxService;

@ServiceName(value={"*"}, type={OutboxService.class})
public class CqnServiceOutboxHandler
implements EventHandler {
    @Before
    private void publishedByOutbox(OutboxMessageEventContext context) {
        Service service = context.getServiceCatalog().getService(context.getEvent());
        if (Boolean.FALSE.equals(context.getIsInbound()) || !(service instanceof CqnService)) {
            return;
        }
        OutboxMessage message = context.getMessage();
        Object v = message.getParams().get("cqn");
        if (v instanceof String) {
            String cqnQuery = (String)v;
            Statement<?> cqn = this.parseCqn(message.getEvent(), cqnQuery, context.getModel());
            message.getParams().put("cqn", cqn);
        }
    }

    @Before
    private void adjustOutboxMessage(OutboxMessageEventContext context) {
        Service service = context.getServiceCatalog().getService(context.getEvent());
        if (Boolean.TRUE.equals(context.getIsInbound()) || !(service instanceof CqnService)) {
            return;
        }
        OutboxMessage message = context.getMessage();
        Object v = message.getParams().get("cqn");
        if (v instanceof CqnStatement) {
            CqnStatement cqn = (CqnStatement)v;
            message.getParams().put("cqn", cqn.toJson());
        }
    }

    private Statement<?> parseCqn(String event, String cqnQuery, CdsModel cdsModel) {
        return switch (event) {
            case "CREATE" -> Insert.cqn((CdsModel)cdsModel, (String)cqnQuery);
            case "DELETE" -> Delete.cqn((String)cqnQuery);
            case "READ" -> Select.cqn((String)cqnQuery);
            case "UPDATE" -> Update.cqn((CdsModel)cdsModel, (String)cqnQuery);
            case "UPSERT" -> Upsert.cqn((CdsModel)cdsModel, (String)cqnQuery);
            default -> Select.cqn((String)cqnQuery);
        };
    }
}

