/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.impl.parser.PathParser;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.ValidatorErrorUtils;
import com.sap.cds.services.impl.utils.ValidatorExecutor;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class NotNullValidator {
    private NotNullValidator() {
    }

    public static void runNotNullCheck(EventContext context, boolean forceException) {
        NotNullValidator.runNotNullCheck(context, forceException, e -> e.isNotNull() && CdsAnnotations.ASSERT_NOTNULL.isTrue((CdsAnnotatable)e), Objects::isNull);
    }

    public static void runNotNullCheck(EventContext context, boolean forceException, Predicate<CdsElement> requiredByModel, Predicate<Object> isNull) {
        DataProcessor processor = DataProcessor.create().addValidator(NotNullValidator.requiresNotNullCheck(requiredByModel), NotNullValidator.assertNotNull(context, forceException, isNull), CdsDataProcessor.Mode.DECLARED);
        Object cqn = context.get("cqn");
        if (cqn instanceof CqnInsert) {
            processor.forInsert();
        } else if (cqn instanceof CqnUpdate || cqn instanceof CqnUpsert) {
            processor.forUpdate();
        }
        ValidatorExecutor.processResolvedEntities((CdsDataProcessor)processor, context);
    }

    private static CdsDataProcessor.Filter requiresNotNullCheck(Predicate<CdsElement> requiredByModel) {
        return (path, element, type) -> {
            CdsElement association;
            List<CdsElement> keyElements;
            Optional optAssociation;
            if (element == null || element.getType().isSimple() && element.defaultValue().isPresent()) {
                return false;
            }
            if (CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrValue((CdsAnnotatable)element, null) != null) {
                return false;
            }
            if (!requiredByModel.test(element)) {
                return false;
            }
            Iterator segments = path.reverse();
            String lastSegment = ((ResolvedSegment)segments.next()).segment().id();
            return !segments.hasNext() || !(optAssociation = ((ResolvedSegment)segments.next()).type().findAssociation(lastSegment)).isPresent() || !(keyElements = CdsModelUtils.getAssociationKeys(association = (CdsElement)optAssociation.get())).contains(element) && !keyElements.stream().anyMatch(k -> element.getName().equals(CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrDefault((CdsAnnotatable)k)));
        };
    }

    private static CdsDataProcessor.Validator assertNotNull(EventContext context, boolean forceException, Predicate<Object> isNull) {
        boolean isPartialUpdate = context.get("cqn") instanceof CqnUpdate;
        return (path, element, value) -> {
            boolean notInRequestBody;
            boolean isAssociation = element.getType().isAssociation();
            boolean bl = notInRequestBody = value == CdsDataProcessor.ABSENT;
            if (isNull.test(value)) {
                NotNullValidator.handleNotNullError(context, forceException, path, element, (CdsStructuredType)element.getDeclaringType());
            } else if (!isPartialUpdate && !isAssociation && notInRequestBody) {
                NotNullValidator.handleNotNullError(context, forceException, path, element, (CdsStructuredType)element.getDeclaringType());
            } else if (notInRequestBody) {
                NotNullValidator.invalidFkElementsOfFwdAssociation(context.getModel(), isPartialUpdate, path, element, isNull).forEach(e -> NotNullValidator.handleNotNullError(context, forceException, path, e, (CdsStructuredType)element.getDeclaringType()));
            }
        };
    }

    private static Stream<CdsElement> invalidFkElementsOfFwdAssociation(CdsModel model, boolean isPartialUpdate, Path path, CdsElement element, Predicate<Object> isNull) {
        boolean isFwdAssociation;
        boolean bl = isFwdAssociation = element.getType().isAssociation() && !com.sap.cds.util.CdsModelUtils.isReverseAssociation((CdsElement)element);
        if (isFwdAssociation) {
            Map parentValues = path.target().values();
            Set<String> fkElements = CdsModelUtils.getFkMapping(model, element, false).keySet();
            Stream<Object> fks = fkElements.stream();
            fks = isPartialUpdate ? fks.filter(e -> parentValues.containsKey(e) && isNull.test(parentValues.get(e))) : fks.filter(e -> !parentValues.containsKey(e) || isNull.test(parentValues.get(e)));
            return fks.map(e -> com.sap.cds.util.CdsModelUtils.element((CdsStructuredType)((CdsStructuredType)element.getDeclaringType()), (List)PathParser.segments((String)e)));
        }
        return Stream.empty();
    }

    private static void handleNotNullError(EventContext context, boolean forceException, Path path, CdsElement element, CdsStructuredType entity) {
        if (CdsModelUtils.isInternalOperationType(element.getDeclaringType().as(CdsDefinition.class))) {
            ValidatorErrorUtils.handleValidationError(context, forceException, path, element, CdsErrorStatuses.MISSING_VALUE, element.getName());
        } else {
            ValidatorErrorUtils.handleValidationError(context, forceException, path, element, CdsErrorStatuses.VALUE_REQUIRED, element.getName(), entity.getQualifiedName());
        }
    }
}

