/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnInSubquery;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.MutablePair;

public class PredicateResolver {
    private final CqnPredicate unresolvedPred;

    private PredicateResolver(CqnPredicate pred) {
        this.unresolvedPred = pred;
    }

    static PredicateResolver create(CqnPredicate pred) {
        if (pred == null) {
            pred = CQL.TRUE;
        }
        return new PredicateResolver(pred);
    }

    CqnPredicate resolve(UserInfo user) {
        return CQL.copy((CqnPredicate)this.unresolvedPred, (Modifier)new UserAttributeSubstitutor(user));
    }

    private static class UserAttributeSubstitutor
    implements Modifier {
        private static final String $TENANT = "$tenant";
        private final UserInfo userInfo;

        public UserAttributeSubstitutor(UserInfo userInfo) {
            this.userInfo = userInfo;
        }

        public CqnPredicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
            MutablePair<List<CqnValue>, Boolean> lhsValuesRaw = this.resolveUserValuesRaw((CqnValue)lhs);
            List lhsValues = (List)lhsValuesRaw.getLeft();
            boolean isUserAttribute = (Boolean)lhsValuesRaw.getRight();
            if (isUserAttribute && rhs.isNullValue()) {
                if (op == CqnComparisonPredicate.Operator.IS) {
                    return lhsValues.isEmpty() ? CQL.TRUE : CQL.FALSE;
                }
                if (op == CqnComparisonPredicate.Operator.IS_NOT) {
                    return !lhsValues.isEmpty() ? CQL.TRUE : CQL.FALSE;
                }
            }
            List<CqnValue> rhsValues = this.resolveUserValues((CqnValue)rhs);
            return (CqnPredicate)lhsValues.stream().flatMap(lhsVal -> rhsValues.stream().map(rhsVal -> CQL.comparison((CqnValue)lhsVal, (CqnComparisonPredicate.Operator)op, (CqnValue)rhsVal))).collect(CQL.withOr());
        }

        public CqnPredicate in(Value<?> value, CqnValue valueSet) {
            List<CqnValue> lhsValues = this.resolveUserValues((CqnValue)value);
            List<Object> rhsValues = valueSet.isList() ? valueSet.asList().values().flatMap(v -> this.resolveUserValues((CqnValue)v).stream()).toList() : this.resolveUserValues(valueSet);
            return (CqnPredicate)lhsValues.stream().map(v -> CQL.in((CqnValue)v, (Collection)rhsValues)).collect(CQL.withOr());
        }

        public CqnPredicate exists(Select<?> subQuery) {
            subQuery.where().ifPresent(w -> subQuery.where((CqnPredicate)CQL.copy((CqnPredicate)w, (Modifier)this)));
            return super.exists(subQuery);
        }

        public CqnPredicate in(CqnInSubquery inSubquery) {
            throw new UnsupportedOperationException("Unsupported predicate: " + inSubquery);
        }

        public CqnPredicate match(CqnMatchPredicate match) {
            if (match.predicate().isPresent()) {
                Predicate pred = CQL.copy((CqnPredicate)((CqnPredicate)match.predicate().get()), (Modifier)this);
                return CQL.match((CqnStructuredTypeRef)match.ref(), (CqnPredicate)pred, (CqnMatchPredicate.Quantifier)match.quantifier());
            }
            return match;
        }

        public CqnValue function(String name, List<Value<?>> args, String cdsType) {
            for (int i = 0; i < args.size(); ++i) {
                List<CqnValue> resolvedValue = this.resolveUserValues((CqnValue)args.get(i));
                if (resolvedValue.size() != 1) {
                    throw new MultipleAttributeValuesNotSupportedException(name, this.extractUserAttribute((CqnValue)args.get(i)));
                }
                args.set(i, (Value)resolvedValue.get(0));
            }
            return super.function(name, args, cdsType);
        }

        public CqnPredicate booleanFunction(String name, List<Value<?>> args) {
            for (int i = 0; i < args.size(); ++i) {
                List<CqnValue> resolvedValue = this.resolveUserValues((CqnValue)args.get(i));
                if (resolvedValue.size() != 1) {
                    throw new MultipleAttributeValuesNotSupportedException(name, this.extractUserAttribute((CqnValue)args.get(i)));
                }
                args.set(i, (Value)resolvedValue.get(0));
            }
            return super.booleanFunction(name, args);
        }

        private List<CqnValue> resolveUserValues(CqnValue val) {
            return (List)this.resolveUserValuesRaw(val).getLeft();
        }

        private MutablePair<List<CqnValue>, Boolean> resolveUserValuesRaw(CqnValue val) {
            String userAttribute = this.extractUserAttribute(val);
            if (userAttribute == null) {
                return MutablePair.of(List.of(val), (Object)false);
            }
            List<Object> result = null;
            switch (userAttribute) {
                case "$user": {
                    result = !StringUtils.isEmpty((String)this.userInfo.getName()) ? List.of(CQL.constant((Object)this.userInfo.getName())) : List.of();
                    break;
                }
                case "$tenant": {
                    result = !StringUtils.isEmpty((String)this.userInfo.getTenant()) ? List.of(CQL.constant((Object)this.userInfo.getTenant())) : List.of();
                    break;
                }
                default: {
                    List attributeValues = this.userInfo.getAttributeValues(userAttribute);
                    result = attributeValues == null || attributeValues.isEmpty() ? List.of() : attributeValues.stream().map(v -> CQL.constant((Object)v)).toList();
                }
            }
            return MutablePair.of(result, (Object)true);
        }

        private String extractUserAttribute(CqnValue val) {
            List segments;
            if (val.isRef() && !(segments = val.asRef().segments()).isEmpty()) {
                String firstSegment = ((CqnReference.Segment)segments.get(0)).id();
                if ("$user".equalsIgnoreCase(firstSegment)) {
                    if (segments.size() == 1) {
                        return "$user";
                    }
                    String attribute = ((CqnReference.Segment)segments.get(1)).id();
                    if ("tenant".equalsIgnoreCase(attribute)) {
                        return $TENANT;
                    }
                    return attribute;
                }
                if (segments.size() == 1 && $TENANT.equalsIgnoreCase(firstSegment)) {
                    return $TENANT;
                }
            }
            return null;
        }
    }

    public static class MultipleAttributeValuesNotSupportedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String attributeName;
        private final String resourceName;

        MultipleAttributeValuesNotSupportedException(String resourceName, String attributeName) {
            this.resourceName = resourceName;
            this.attributeName = attributeName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

