/*
 * © 2019-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl;

import com.sap.cds.services.ServiceExceptionUtils;
import com.sap.cds.services.environment.CdsProperties.Errors;
import com.sap.cds.services.impl.messages.SimpleLocalizedMessageProvider;
import com.sap.cds.services.impl.request.RequestContextImpl;
import com.sap.cds.services.impl.utils.DefaultTranslationUtils;
import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.request.RequestContext;
import java.util.Locale;

public class ServiceExceptionUtilsImpl implements ServiceExceptionUtils {

  public static LocalizedMessageProvider defaultLocalizedMessageProvider =
      new SimpleLocalizedMessageProvider();
  public static Errors errorsProperties = new Errors();

  @Override
  public String getMessage(String code, Object[] args) {
    // for ErrorStatuses we prefer the unlocalized description text in logs and stack traces
    return DefaultTranslationUtils.getErrorStatusDescription(code, args)
        .orElseGet(() -> defaultLocalizedMessageProvider.get(code, args, null));
  }

  @Override
  public String getLocalizedMessage(
      String code, Object[] args, Locale locale, boolean errorStatusFallback) {
    Locale theLocale = locale;
    if (theLocale == null) {
      // try to resolve locale from request context (only works if one was explicitly opened)
      RequestContext requestContext = RequestContextImpl.getCurrentInternal();
      theLocale = requestContext != null ? requestContext.getParameterInfo().getLocale() : null;
    }
    return DefaultTranslationUtils.getLocalizedMessage(
        defaultLocalizedMessageProvider,
        code,
        args,
        theLocale,
        errorsProperties,
        errorStatusFallback);
  }

  @Override
  public Errors getErrorsProperties() {
    return errorsProperties;
  }
}
