/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.DataAccessLog;
import com.sap.cds.services.auditlog.DataAccessLogContext;
import com.sap.cds.services.impl.EventContextDelegator;
import java.time.Instant;

public class DataAccessLogContextImpl extends EventContextDelegator
    implements DataAccessLogContext {
  private static final String PARAM_DATA = "data";
  private static final String PARAM_CREATED_AT = "createdAt";

  public DataAccessLogContextImpl(EventContext eventContext) {
    super(eventContext);
  }

  @Override
  public AuditLogService getService() {
    return (AuditLogService) super.getService();
  }

  public DataAccessLog getData() {
    return (DataAccessLog) get(PARAM_DATA);
  }

  public void setData(DataAccessLog event) {
    put(PARAM_DATA, event);
  }

  public Instant getCreatedAt() {
    return (Instant) get(PARAM_CREATED_AT);
  }

  public void setCreatedAt(Instant createdAt) {
    put(PARAM_CREATED_AT, createdAt);
  }
}
