/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.authorization.ServiceAccessEventContext;
import com.sap.cds.services.impl.EventContextDelegator;

public class ServiceAccessEventContextImpl extends EventContextDelegator
    implements ServiceAccessEventContext {

  public ServiceAccessEventContextImpl(EventContext eventContext) {
    super(eventContext);
  }

  @Override
  public AuthorizationService getService() {
    return (AuthorizationService) super.getService();
  }

  private static final String PARAM_ACCESS_SERVICE_NAME = "accessServiceName";

  private static final String PARAM_ACCESS_EVENT_NAME = "accessEventName";

  private static final String PARAM_RESULT = "result";

  // IN
  public void setAccessServiceName(String service) {
    put(PARAM_ACCESS_SERVICE_NAME, service);
  }

  public String getAccessServiceName() {
    return (String) get(PARAM_ACCESS_SERVICE_NAME);
  }

  public void setAccessEventName(String event) {
    put(PARAM_ACCESS_EVENT_NAME, event);
  }

  public String getAccessEventName() {
    return (String) get(PARAM_ACCESS_EVENT_NAME);
  }

  // OUT
  public Boolean getResult() {
    return (Boolean) get(PARAM_RESULT);
  }

  public void setResult(boolean result) {
    put(PARAM_RESULT, result);
    setCompleted();
  }
}
