/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftCancelEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.utils.ResultUtils;
import java.util.Map;

/**
 * Implementation of the {@link EventContext} for the {@link DraftService#EVENT_DRAFT_CANCEL} event.
 */
public class DraftCancelEventContextImpl extends EventContextDelegator
    implements DraftCancelEventContext {

  public DraftCancelEventContextImpl(EventContext eventContext) {
    super(eventContext);
  }

  @Override
  public DraftService getService() {
    return (DraftService) super.getService();
  }

  private static final String PARAM_CQN = "cqn";
  private static final String PARAM_CQN_VALUE_SETS = "cqnValueSets";
  private static final String PARAM_RESULT = "result";

  // IN
  public CqnDelete getCqn() {
    return (CqnDelete) get(PARAM_CQN);
  }

  public void setCqn(CqnDelete cqn) {
    put(PARAM_CQN, cqn);
  }

  @SuppressWarnings("unchecked")
  public Iterable<Map<String, Object>> getCqnValueSets() {
    return (Iterable<Map<String, Object>>) get(PARAM_CQN_VALUE_SETS);
  }

  public void setCqnValueSets(Iterable<Map<String, Object>> valueSets) {
    put(PARAM_CQN_VALUE_SETS, valueSets);
  }

  // OUT
  public Result getResult() {
    return (Result) get(PARAM_RESULT);
  }

  public void setResult(Iterable<? extends Map<String, ?>> result) {
    put(PARAM_RESULT, ResultUtils.convert(result));
    setCompleted();
  }
}
