/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;

/**
 * Handles all types of {@link CqnStatement} and {@link CqnStructuredTypeRef} based arguments in
 * handler methods
 */
public class CqnStatementArgumentResolver implements ArgumentResolver {

  public static CqnStatementArgumentResolver createIfApplicable(Class<?> type) {
    if (CqnStatement.class.isAssignableFrom(type)) {
      return new CqnStatementArgumentResolver(type);
    }
    return null;
  }

  private final Class<? extends CqnStatement> cqnStatementType;

  @SuppressWarnings("unchecked")
  private CqnStatementArgumentResolver(Class<?> type) {
    this.cqnStatementType = (Class<? extends CqnStatement>) type;
  }

  @Override
  public Object resolve(EventContext context) {
    return cqnStatementType.cast(context.get("cqn"));
  }

  @Override
  public void verifyOrThrow(HandlerDescriptor descriptor) {
    // not yet validated
  }
}
