/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;

/** Describes how to resolve a certain return value on a given {@link EventContext} */
public interface ReturnResolver {

  /**
   * Resolves the return value against the given {@link EventContext}. The method should put the
   * return value on the {@link EventContext} under the expected key.
   *
   * @param returnValue the return value
   * @param context the context, which is currently being processed
   */
  void resolve(Object returnValue, EventContext context);

  /**
   * Verifies the resolver, based on the final {@link HandlerDescriptor}.
   *
   * @param descriptor the {@link HandlerDescriptor}
   * @throws IllegalArgumentException if the verification failed
   */
  void verifyOrThrow(HandlerDescriptor descriptor);
}
