/*
 * © 2019-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.messages;

import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageLookup;
import com.sap.cds.services.messages.MessageTarget;
import java.util.List;
import java.util.Objects;

public class MessageImpl implements Message {

  private final Severity severity;
  private final String message;
  private final MessageLookup messageLookup;

  private String code;
  private String longTextUrl;
  private MessageTarget target;
  private List<MessageTarget> additionalTargets = List.of();
  private boolean isTransition;

  public MessageImpl(Severity severity, String message) {
    this(severity, message, MessageLookup.create(message, null));
  }

  public MessageImpl(Severity severity, String message, MessageLookup messageLookup) {
    this.severity = Objects.requireNonNull(severity, "severity must not be null");
    this.message = Objects.requireNonNull(message, "message must not be null");
    this.messageLookup = Objects.requireNonNull(messageLookup, "messageLookup must not be null");
  }

  @Override
  public Severity getSeverity() {
    return severity;
  }

  @Override
  public String getMessage() {
    return message;
  }

  @Override
  public MessageLookup getMessageLookup() {
    return messageLookup;
  }

  @Override
  public String getCode() {
    return code;
  }

  @Override
  public MessageTarget getTarget() {
    return target;
  }

  @Override
  public List<MessageTarget> getAdditionalTargets() {
    return additionalTargets;
  }

  @Override
  public String getLongTextUrl() {
    return longTextUrl;
  }

  @Override
  public boolean isTransition() {
    return isTransition;
  }

  @Override
  public Message longTextUrl(String longTextUrl) {
    this.longTextUrl = longTextUrl;
    return this;
  }

  @Override
  public Message code(String code) {
    this.code = code;
    return this;
  }

  @Override
  public Message transition(boolean isTransition) {
    this.isTransition = isTransition;
    return this;
  }

  @Override
  public Message target(MessageTarget target) {
    this.target = target;
    return this;
  }

  @Override
  public Message additionalTargets(List<MessageTarget> additionalTargets) {
    this.additionalTargets = additionalTargets;
    return this;
  }
}
