/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.messaging.composite;

import com.sap.cds.services.environment.CdsProperties.Composite.CompositeServiceConfig;
import com.sap.cds.services.environment.CdsProperties.Composite.CompositeServiceConfig.Route;
import com.sap.cds.services.impl.composite.CompositeService;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingCompositeService extends CompositeService implements MessagingService {

  private static final Logger logger = LoggerFactory.getLogger(MessagingCompositeService.class);

  public MessagingCompositeService(String name, List<Route> routes, CdsRuntime runtime) {
    super(toCompositeConfig(name, routes), runtime);
  }

  @Override
  public void emit(String topic, Map<String, Object> message) {
    getDestinationServiceAndLog(topic).emit(topic, message);
  }

  @Override
  public void emit(String topic, Map<String, Object> data, Map<String, Object> headers) {
    getDestinationServiceAndLog(topic).emit(topic, data, headers);
  }

  private MessagingService getDestinationServiceAndLog(String topic) {
    MessagingService destinationService = (MessagingService) getDestinationService(topic);
    logger.debug("Emitting the event '{}' on service '{}'", topic, destinationService.getName());
    return destinationService;
  }

  private static CompositeServiceConfig toCompositeConfig(String name, List<Route> routes) {
    CompositeServiceConfig result = new CompositeServiceConfig();
    result.setName(name);
    result.setRoutes(routes);
    return result;
  }
}
