/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.mt.DependenciesEventContext;
import com.sap.cds.services.mt.DeploymentService;
import com.sap.cds.services.mt.SubscribeEventContext;
import com.sap.cds.services.mt.UnsubscribeEventContext;
import com.sap.cds.services.mt.UpgradeEventContext;
import com.sap.cds.services.utils.OrderConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentServiceImpl extends ServiceDelegator implements DeploymentService {

  public DeploymentServiceImpl(String name) {
    super(name);
  }

  @Override
  public List<Map<String, Object>> dependencies() {
    DependenciesEventContext context = DependenciesEventContext.create();
    emit(context);
    return context.getResult();
  }

  @Override
  public void subscribe(String tenant, Map<String, Object> options) {
    SubscribeEventContext context = SubscribeEventContext.create();
    context.setTenant(tenant);
    context.setOptions(options == null ? new HashMap<>() : options);
    emit(context);
  }

  @Override
  public void upgrade(List<String> tenants, Map<String, Object> options) {
    UpgradeEventContext context = UpgradeEventContext.create();
    context.setTenants(tenants == null ? new ArrayList<>() : tenants);
    context.setOptions(options == null ? new HashMap<>() : options);
    emit(context);
  }

  @Override
  public void unsubscribe(String tenant, Map<String, Object> options) {
    UnsubscribeEventContext context = UnsubscribeEventContext.create();
    context.setTenant(tenant);
    context.setOptions(options == null ? new HashMap<>() : options);
    emit(context);
  }

  @On
  @HandlerOrder(OrderConstants.On.DEFAULT_ON)
  private void defaultDependencies(DependenciesEventContext context) {
    context.setResult(new ArrayList<>());
  }

  @On(event = {EVENT_SUBSCRIBE, EVENT_UPGRADE, EVENT_UNSUBSCRIBE})
  @HandlerOrder(OrderConstants.On.AUTO_COMPLETE)
  private void autoComplete(EventContext context) {
    context.setCompleted();
  }
}
