/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.outbox.persistence.collectors;

public interface OutboxCollector {

  /** Starts the collector */
  public void start();

  /**
   * Stops the collector
   *
   * @param waitMillis millis to wait for a stopped collector.
   */
  public void stop(long waitMillis) throws InterruptedException;

  /**
   * @return true, if the collector is currently running
   */
  public boolean isRunning();

  /**
   * Schedules the collector execution for the given tenant
   *
   * @param tenant the tenant
   * @param delay the delay in millis
   * @param withEmptyCheck checks if empty before scheduling
   */
  public void schedule(String tenant, long delay, boolean withEmptyCheck);
}
