/*
 * © 2020-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.utils.model.CdsModelUtils;
import java.util.List;

public abstract class TargetAwareCqnModifier implements Modifier {

  private final CdsEntity target;

  protected TargetAwareCqnModifier(CdsEntity target) {
    this.target = target;
  }

  protected abstract TargetAwareCqnModifier create(CdsEntity target);

  @Override
  public CqnSelectListItem expand(CqnExpand expand) {
    CdsEntity refTarget = getRefTarget(expand.ref());

    if (refTarget != null) {
      // copy selection deep
      List<CqnSelectListItem> items = expand.items();
      Modifier modifier = create(refTarget);
      items = modifier.items(ExpressionVisitor.copy(items, modifier));
      return CQL.copy(expand).items(items);
    }
    return expand;
  }

  protected CdsEntity getTarget() {
    return target;
  }

  protected CdsEntity getRefTarget(CqnStructuredTypeRef ref) {
    return CdsModelUtils.getRefTarget(ref, target);
  }
}
