/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import java.util.Collection;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ExpandRestrictionsHandler
implements EventHandler {
    private final int defaultMaxLevelsLimit;

    public ExpandRestrictionsHandler(CdsRuntime runtime) {
        this.defaultMaxLevelsLimit = runtime.getEnvironment().getCdsProperties().getQuery().getRestrictions().getExpand().getMaxLevels();
    }

    @Before
    @HandlerOrder(value=-10900)
    void enforceExpandRestrictions(CdsReadEventContext context) {
        ExpandValidator checker = new ExpandValidator((CdsStructuredType)context.getTarget(), -1);
        context.getCqn().items().stream().filter(CqnSelectListItem::isExpand).forEach(i -> checker.validate(i.asExpand()));
    }

    private class ExpandValidator {
        private final CdsStructuredType entity;
        private final Collection<String> nonExpandableProperties;
        private final int limit;

        private ExpandValidator(CdsStructuredType entity, int remainingLimit) {
            this.entity = entity;
            this.nonExpandableProperties = CdsAnnotations.NON_EXPANDABLE_PROPERTIES.asCollectionOfValues((CdsAnnotatable)entity);
            int currentLimit = (Integer)CdsAnnotations.EXPAND_MAX_LEVELS.getOrValue((CdsAnnotatable)entity, (Object)ExpandRestrictionsHandler.this.defaultMaxLevelsLimit);
            this.limit = remainingLimit < 0 || currentLimit >= 0 && currentLimit < remainingLimit ? currentLimit : remainingLimit;
        }

        public void validate(CqnExpand expand) {
            if (!CdsAnnotations.EXPANDABLE.isTrue((CdsAnnotatable)this.entity)) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NOT_EXPANDABLE, new Object[]{this.entity.getQualifiedName()});
            }
            if (this.nonExpandableProperties.contains(expand.ref().firstSegment())) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NON_EXPANDABLE_PROPERTY, new Object[]{expand.ref().firstSegment(), this.entity.getQualifiedName()});
            }
            if (this.limit == 0) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TOO_MANY_EXPANDS, new Object[0]);
            }
            int nextLimit = this.limit > 0 ? this.limit - 1 : this.limit;
            CdsStructuredType target = CdsModelUtils.getTargetOf((CdsStructuredType)this.entity, (String)expand.ref().path());
            ExpandValidator checker = new ExpandValidator(target, nextLimit);
            expand.items().stream().filter(CqnSelectListItem::isExpand).forEach(i -> checker.validate(i.asExpand()));
        }
    }
}

