/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox.persistence;

import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationStoppedEventContext;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.outbox.persistence.PersistentOutbox;
import com.sap.cds.services.impl.outbox.persistence.collectors.TenantCache;
import com.sap.cds.services.impl.scheduler.TaskScheduler;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class PersistentOutboxInitializationHandler
implements EventHandler {
    private final TenantCache tenantCache;
    private final TaskScheduler taskScheduler;

    public PersistentOutboxInitializationHandler(TenantCache tenantCache, TaskScheduler taskScheduler) {
        this.tenantCache = tenantCache;
        this.taskScheduler = taskScheduler;
    }

    @After
    protected void initOutboxCollectors(ApplicationPreparedEventContext context) {
        if (context.getCdsRuntime().getEnvironment().getCdsProperties().getEnvironment().getCommand().isEnabled().booleanValue()) {
            return;
        }
        if (this.taskScheduler != null) {
            this.taskScheduler.start();
        } else {
            this.tenantCache.start(context.getCdsRuntime());
        }
        context.getCdsRuntime().getServiceCatalog().getServices(PersistentOutbox.class).forEach(PersistentOutbox::init);
        CdsProperties.Outbox.Persistent.Scheduler schedulerCfg = context.getCdsRuntime().getEnvironment().getCdsProperties().getOutbox().getPersistent().getScheduler();
        if (this.taskScheduler != null && schedulerCfg.getAllTenantsTask().isEnabled().booleanValue()) {
            this.taskScheduler.scheduleTask("OutboxTenantsTask", new AllTenantsTask(context.getCdsRuntime()), schedulerCfg.getAllTenantsTask().getExecutionStartDelay().toMillis());
        }
    }

    @On
    protected void stopOutboxCollectors(ApplicationStoppedEventContext context) {
        context.getCdsRuntime().getServiceCatalog().getServices(PersistentOutbox.class).forEach(PersistentOutbox::stop);
        if (this.taskScheduler != null) {
            this.taskScheduler.shutdown();
        } else {
            this.tenantCache.stop();
        }
    }

    private static class AllTenantsTask
    implements TaskScheduler.Task {
        private final TenantProviderService tenantService;
        private final List<PersistentOutbox> outboxServices;
        private final long allTenantsInterval;
        private final long allTenantsSpreadTime;

        public AllTenantsTask(CdsRuntime runtime) {
            this.tenantService = (TenantProviderService)runtime.getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
            this.outboxServices = runtime.getServiceCatalog().getServices(PersistentOutbox.class).toList();
            CdsProperties.Outbox.Persistent.Scheduler schedulerCfg = runtime.getEnvironment().getCdsProperties().getOutbox().getPersistent().getScheduler();
            this.allTenantsInterval = schedulerCfg.getAllTenantsTask().getInterval().toMillis();
            this.allTenantsSpreadTime = schedulerCfg.getAllTenantsTask().getExecutionSpreadTime().toMillis();
        }

        @Override
        public TaskScheduler.TaskSchedule run() {
            this.tenantService.readTenants().forEach(tenant -> this.outboxServices.forEach(outbox -> {
                long delay = ThreadLocalRandom.current().nextLong(this.allTenantsSpreadTime);
                outbox.schedule((String)tenant, delay, true);
            }));
            return new TaskScheduler.TaskSchedule(this, this.allTenantsInterval, true);
        }
    }
}

