/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.request;

import com.sap.cds.services.request.FeatureToggle;
import com.sap.cds.services.request.FeatureTogglesInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FeatureTogglesInfoFactory {
    public static FeatureTogglesInfo create(List<FeatureToggle> featureToggles) {
        return new FeatureTogglesInfoImpl(featureToggles.stream().collect(Collectors.toMap(ft -> ft.getName(), ft -> ft)));
    }

    public static FeatureTogglesInfo create(Map<String, Boolean> featureToggles) {
        return new FeatureTogglesInfoImpl(featureToggles.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new FeatureToggleImpl((String)e.getKey(), (Boolean)e.getValue()))));
    }

    private static class FeatureTogglesInfoImpl
    implements FeatureTogglesInfo {
        private final Map<String, FeatureToggle> features;

        private FeatureTogglesInfoImpl(Map<String, FeatureToggle> features) {
            this.features = features;
        }

        public boolean isEnabled(String feature) {
            if (this.features.containsKey("*") && this.features.get("*").isEnabled()) {
                return true;
            }
            return this.features.containsKey(feature) && this.features.get(feature).isEnabled();
        }

        public Stream<FeatureToggle> getFeatureToggles() {
            return this.features.values().stream();
        }

        public Stream<FeatureToggle> getEnabledFeatureToggles() {
            return this.getFeatureToggles().filter(FeatureToggle::isEnabled);
        }

        public FeatureToggle getFeatureToggle(String feature) {
            return this.features.get(feature);
        }
    }

    private static class FeatureToggleImpl
    implements FeatureToggle {
        private final String name;
        private final boolean enabled;

        public FeatureToggleImpl(String name, boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

