/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class FilterRestrictionsHandler
implements EventHandler {
    @Before
    @HandlerOrder(value=-10900)
    void validateFilterRestrictions(CdsReadEventContext context) {
        CdsEntity target = context.getTarget();
        CqnSelect select = context.getCqn();
        FilterRestrictionsHandler.validate((CdsStructuredType)target, select.where());
        FilterRestrictionsHandler.expands(select.items()).forEach(exp -> this.validateExpand((CdsStructuredType)target, (CqnExpand)exp));
    }

    private void validateExpand(CdsStructuredType target, CqnExpand expand) {
        CdsStructuredType tt = CdsModelUtils.getTargetOf((CdsStructuredType)target, (String)expand.ref().path());
        FilterRestrictionsHandler.validate(tt, expand.ref().targetSegment().filter());
        FilterRestrictionsHandler.expands(expand.items()).forEach(exp -> this.validateExpand(tt, (CqnExpand)exp));
    }

    private static Stream<CqnExpand> expands(List<CqnSelectListItem> items) {
        return items.stream().filter(i -> i.isExpand()).map(i -> i.asExpand());
    }

    private static void validate(CdsStructuredType target, Optional<CqnPredicate> filter) {
        boolean isFilterable = (Boolean)CdsAnnotations.FILTERABLE.getOrDefault((CdsAnnotatable)target);
        boolean isFilterRequired = (Boolean)CdsAnnotations.REQUIRES_FILTER.getOrDefault((CdsAnnotatable)target);
        final Collection requiredFilterProperties = CdsAnnotations.REQUIRED_FILTER_PROPERTIES.asCollectionOfValues((CdsAnnotatable)target);
        final Collection nonFilterableProperties = CdsAnnotations.NON_FILTERABLE_PROPERTIES.asCollectionOfValues((CdsAnnotatable)target);
        if (!isFilterable && FilterRestrictionsHandler.isEffectiveFilter(filter)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NOT_FILTERABLE, new Object[]{target.getQualifiedName()});
        }
        if (isFilterRequired && !FilterRestrictionsHandler.isEffectiveFilter(filter)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.FILTER_MISSING, new Object[]{target.getQualifiedName()});
        }
        if (!requiredFilterProperties.isEmpty() || !nonFilterableProperties.isEmpty()) {
            filter.ifPresent(f -> f.accept(new CqnVisitor(){

                public void visit(CqnElementRef elementRef) {
                    String el = elementRef.firstSegment();
                    requiredFilterProperties.remove(el);
                    if (nonFilterableProperties.contains(el)) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NON_FILTERABLE_PROPERTY, new Object[]{el});
                    }
                }
            }));
            if (!requiredFilterProperties.isEmpty()) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.FILTER_PROPERTY_MISSING, new Object[]{requiredFilterProperties.stream().collect(Collectors.joining(","))});
            }
        }
    }

    private static boolean isEffectiveFilter(Optional<CqnPredicate> filter) {
        return filter.map(f -> CQL.TRUE != f).orElse(false);
    }
}

