/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnInline;
import com.sap.cds.ql.cqn.CqnSelectList;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.Iterator;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class RejectExpandInlineAllHandler
implements EventHandler {
    @Before(event={"READ"})
    @HandlerOrder(value=-10900)
    public void verifyStatement(CdsReadEventContext context) {
        StarChecker hasForbiddenStar = new StarChecker();
        context.getCqn().accept((CqnVisitor)hasForbiddenStar);
        if (hasForbiddenStar.isFound()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_STAR, new Object[0]);
        }
    }

    private static class StarChecker
    implements CqnVisitor {
        private boolean found;

        private StarChecker() {
        }

        public boolean isFound() {
            return this.found;
        }

        public void visit(CqnExpand expand) {
            this.checkSelectList((CqnSelectList)expand);
        }

        public void visit(CqnInline inline) {
            this.checkSelectList((CqnSelectList)inline);
        }

        private void checkSelectList(CqnSelectList selector) {
            if (!this.found) {
                CqnStructuredTypeRef ref = selector.ref();
                boolean bl = this.found = selector.ref().segments().isEmpty() || "*".equals(ref.targetSegment().id());
                if (!this.found) {
                    this.visitItems(selector);
                }
            }
        }

        private void visitItems(CqnSelectList selector) {
            Iterator iterator = selector.items().iterator();
            while (!this.found && iterator.hasNext()) {
                CqnSelectListItem i = (CqnSelectListItem)iterator.next();
                if (!i.isSelectList()) continue;
                i.accept((CqnVisitor)this);
            }
        }
    }
}

