/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.messages.Message;
import java.util.Set;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ValidationErrorHandler
implements EventHandler {
    public static final String THROW_IF_ERROR_IN_AFTER = "cds.internal.validations.throwIfErrorInAfter";
    public static final String PREVIOUS_MESSAGES_KEY = "cds.internal.validations.previousMessages";

    @Before
    @HandlerOrder(value=-10499)
    public void keepPreviousMessages(EventContext context) {
        Set previousMessages = context.getMessages().stream().collect(Collectors.toSet());
        context.put(PREVIOUS_MESSAGES_KEY, previousMessages);
    }

    @Before
    @HandlerOrder(value=11200)
    public void throwIfErrorInBefore(EventContext context) {
        if (!context.keySet().contains(THROW_IF_ERROR_IN_AFTER)) {
            this.throwIfError(context);
        }
    }

    @After
    @HandlerOrder(value=11000)
    public void throwIfErrorInAfter(EventContext context) {
        if (context.keySet().contains(THROW_IF_ERROR_IN_AFTER)) {
            this.throwIfError(context);
        }
    }

    private void throwIfError(EventContext context) {
        if (context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().isCombined()) {
            Set previousMessages = (Set)context.get(PREVIOUS_MESSAGES_KEY);
            if (context.getMessages().stream().anyMatch(m -> !previousMessages.contains(m) && m.getSeverity().equals((Object)Message.Severity.ERROR))) {
                context.getMessages().throwIfError();
            }
        }
    }
}

