/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft.messages;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.impl.parser.TokenParser;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.impl.draft.messages.DraftMessage;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageLookup;
import com.sap.cds.services.messages.MessageTarget;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DraftMessageUtils {
    public static final String MESSAGES_ELEMENT = "DraftMessages";
    public static final String MESSAGES_PATH = "DraftAdministrativeData.DraftMessages";

    public static boolean isDraftMessagesEnabled(CdsModel model) {
        return model.findEntity("DRAFT.DraftAdministrativeData").flatMap(e -> e.findElement(MESSAGES_ELEMENT)).isPresent();
    }

    public static boolean isDraftMessagesStored(EventContext context) {
        return Boolean.TRUE.equals(context.get("cds.internal.draftMessages.storeMessages"));
    }

    public static List<DraftMessage> toDraftMessages(ServiceException exception, Messages messages) {
        ArrayList<DraftMessage> draftMessages = new ArrayList<DraftMessage>();
        if (exception != null && !exception.isTransition()) {
            DraftMessage draftMessage = DraftMessage.create();
            draftMessage.setMessage(DraftMessageUtils.stringifyMessageLookup(exception.getMessageLookup()));
            draftMessage.setNumericSeverity((short)Message.Severity.ERROR.getNumericSeverity());
            draftMessage.setCode(exception.getErrorStatus().getCodeString());
            if (exception.getLongTextUrl() != null) {
                draftMessage.setLongtextUrl(exception.getLongTextUrl());
            }
            if (exception.getMessageTarget() != null) {
                draftMessage.setTarget(DraftMessageUtils.stringifyMessageTarget(exception.getMessageTarget()));
            }
            if (!exception.getAdditionalTargets().isEmpty()) {
                draftMessage.setAdditionalTargets(exception.getAdditionalTargets().stream().map(t -> DraftMessageUtils.stringifyMessageTarget(t)).toList());
            }
            draftMessage.setTransition(exception.isTransition());
            draftMessages.add(draftMessage);
        }
        messages.stream().filter(m -> !m.isTransition()).forEach(m -> draftMessages.add(DraftMessageUtils.toDraftMessage(m, null)));
        return draftMessages;
    }

    public static DraftMessage toDraftMessage(Message message, CqnStructuredTypeRef targetPrefix) {
        DraftMessage draftMessage = DraftMessage.create();
        draftMessage.setMessage(DraftMessageUtils.stringifyMessageLookup(message.getMessageLookup()));
        draftMessage.setNumericSeverity((short)message.getSeverity().getNumericSeverity());
        if (message.getCode() != null) {
            draftMessage.setCode(message.getCode());
        }
        if (message.getLongTextUrl() != null) {
            draftMessage.setLongtextUrl(message.getLongTextUrl());
        }
        if (message.getTarget() != null) {
            draftMessage.setTarget(DraftMessageUtils.stringifyMessageTarget(DraftMessageUtils.prefixMessageTarget(targetPrefix, message.getTarget())));
        }
        if (!message.getAdditionalTargets().isEmpty()) {
            draftMessage.setAdditionalTargets(message.getAdditionalTargets().stream().map(t -> DraftMessageUtils.stringifyMessageTarget(DraftMessageUtils.prefixMessageTarget(targetPrefix, t))).toList());
        }
        draftMessage.setTransition(message.isTransition());
        return draftMessage;
    }

    public static String stringifyMessageLookup(MessageLookup lookup) {
        return Jsonizer.json(Map.of("key", lookup.getMessageOrKey(), "args", Arrays.asList(lookup.getArgs())));
    }

    public static MessageLookup parseMessageLookup(String message) {
        Map parsed = JsonParser.map((JsonNode)JsonParser.parseJson((String)message));
        String key = (String)parsed.get("key");
        List args = (List)parsed.get("args");
        return MessageLookup.create((String)key, (Object[])args.toArray());
    }

    public static String stringifyMessageTarget(MessageTarget target) {
        if (target == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("parameter", target.getParameter());
        map.put("ref", target.getRef() != null ? target.getRef().toJson() : null);
        return Jsonizer.json(map);
    }

    public static MessageTarget parseMessageTarget(String json) {
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        Map map = JsonParser.map((JsonNode)JsonParser.parseJson((String)json));
        String parameter = (String)map.get("parameter");
        String refString = (String)map.get("ref");
        StructuredTypeRef ref = refString != null ? TokenParser.ref((JsonNode)JsonParser.parseJson((String)refString)) : null;
        return MessageTarget.create((String)parameter, (CqnReference)ref);
    }

    public static MessageTarget prefixMessageTarget(CqnStructuredTypeRef ref, MessageTarget target) {
        if (ref != null && ref.size() > 1 && target.getRef() != null) {
            ArrayList segments = new ArrayList(ref.segments().subList(1, ref.size()));
            segments.addAll(target.getRef().segments());
            return MessageTarget.create((String)target.getParameter(), (CqnReference)CQL.to(segments).asRef());
        }
        return target;
    }

    public static CqnStructuredTypeRef forTarget(CqnStructuredTypeRef ref) {
        return ref.size() > 1 ? CQL.to(ref.segments().subList(1, ref.size())).asRef() : null;
    }
}

