/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.utils.info.CdsInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfo {
    private static final Logger logger = LoggerFactory.getLogger(BuildInfo.class);

    public static void log(CdsProperties props) {
        Git gitInfo = new Git();
        gitInfo.info(CdsInfo.Details.LOW).entrySet().stream().forEach(m -> logger.info(gitInfo.name() + "." + (String)m.getKey() + ": " + String.valueOf(m.getValue())));
        Maven mavenInfo = new Maven();
        mavenInfo.info(CdsInfo.Details.LOW).entrySet().stream().forEach(m -> logger.info(mavenInfo.name() + "." + (String)m.getKey() + ": " + String.valueOf(m.getValue())));
        String deploymentVersion = props.getEnvironment().getDeployment().getVersion();
        if (deploymentVersion != null) {
            logger.info("deployment.version: {}", (Object)deploymentVersion);
        }
    }

    public static class Git
    extends CdsPropertyInfo {
        private static final String GIT_PROPERTIES_LOCATION = "/com/sap/cds/cds-services-git.properties";
        private static Map<String, KeyInfo> gitKeyMap = new HashMap<String, KeyInfo>(){
            {
                this.put("commit.id", new KeyInfo("git.commit.id", CdsInfo.Details.LOW));
                this.put("commit.time", new KeyInfo("git.commit.time", CdsInfo.Details.HIGH));
            }
        };

        public Git() {
            super(GIT_PROPERTIES_LOCATION, gitKeyMap);
        }

        public String name() {
            return "git";
        }
    }

    public static class Maven
    extends CdsPropertyInfo {
        private static final String BUILD_PROPERTIES_LOCATION = "/com/sap/cds/cds-services-build-info.properties";
        private static Map<String, KeyInfo> mavenKeyMap = new HashMap<String, KeyInfo>(){
            {
                this.put("version", new KeyInfo("build.version", CdsInfo.Details.LOW));
                this.put("artifact", new KeyInfo("build.artifact", CdsInfo.Details.MEDIUM));
                this.put("group", new KeyInfo("build.group", CdsInfo.Details.MEDIUM));
                this.put("name", new KeyInfo("build.name", CdsInfo.Details.MEDIUM));
                this.put("time", new KeyInfo("build.time", CdsInfo.Details.HIGH));
                this.put("java.source", new KeyInfo("build.java.source", CdsInfo.Details.HIGH));
                this.put("java.target", new KeyInfo("build.java.target", CdsInfo.Details.HIGH));
            }
        };

        public Maven() {
            super(BUILD_PROPERTIES_LOCATION, mavenKeyMap);
        }

        public String name() {
            return "maven";
        }
    }

    static abstract class CdsPropertyInfo
    implements CdsInfo {
        Map<String, Object> info = new HashMap<String, Object>();
        Map<String, KeyInfo> keyMap;

        CdsPropertyInfo(String resourceLocation, Map<String, KeyInfo> keyMap) {
            this.keyMap = keyMap;
            try {
                this.info = Collections.unmodifiableMap(CdsPropertyInfo.loadFrom(resourceLocation, key -> keyMap.entrySet().stream().filter(e -> ((KeyInfo)e.getValue()).fileKey.equalsIgnoreCase((String)key)).map(Map.Entry::getKey).findAny().orElse(null)));
            }
            catch (IOException e) {
                logger.error("Failed to load info from {}", (Object)resourceLocation, (Object)e);
            }
        }

        public Map<String, Object> info(CdsInfo.Details details) {
            return this.info.entrySet().stream().filter(g -> this.keyMap.get(g.getKey()).details.ordinal() <= details.ordinal()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private static Map<String, Object> loadFrom(String location, UnaryOperator<String> keyMapper) throws IOException {
            Properties source = new Properties();
            InputStream is = BuildInfo.class.getResourceAsStream(location);
            if (is != null) {
                try (InputStream inputStream = is;){
                    source.load(is);
                }
                HashMap<String, Object> result = new HashMap<String, Object>();
                for (String fullKey : source.stringPropertyNames()) {
                    Object value;
                    String key = (String)keyMapper.apply(fullKey);
                    if (key == null || (value = source.get(fullKey)) == null || value.toString().isEmpty()) continue;
                    HashMap<String, Object> map = result;
                    map.put(key, value);
                }
                return result;
            }
            logger.warn("Info resource '{}' is missing.", (Object)location);
            return Collections.emptyMap();
        }
    }

    private static class KeyInfo {
        String fileKey;
        CdsInfo.Details details;

        KeyInfo(String fileKey, CdsInfo.Details details) {
            this.fileKey = fileKey;
            this.details = details;
        }
    }
}

