/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.LocaleUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.helpers.MessageFormatter;

public class DefaultTranslationUtils {
    public static final String BUNDLE_NAME = "com.sap.cds.i18n.errors";
    private static final Set<String> KEYS = ResourceBundle.getBundle("com.sap.cds.i18n.errors", Locale.ROOT).keySet();
    private static final Map<String, ErrorStatus> errorStatuses = new HashMap<String, ErrorStatus>();

    public static Optional<String> getErrorStatusDescription(String code, Object[] args) {
        ErrorStatus status = errorStatuses.get(code);
        if (status != null) {
            return Optional.of(MessageFormatter.arrayFormat((String)status.getDescription(), (Object[])args).getMessage());
        }
        return Optional.empty();
    }

    public static String getLocalizedMessage(LocalizedMessageProvider provider, String code, Object[] args, Locale locale, CdsProperties.Errors config, boolean errorStatusFallback) {
        ErrorStatus status;
        Locale theLocale;
        ResourceBundle bundle;
        String localized = provider.get(code, args, locale);
        if (config.getDefaultTranslations().isEnabled().booleanValue() && KEYS.contains(code) && Objects.equals(code, localized) && (bundle = ResourceBundle.getBundle(BUNDLE_NAME, theLocale = locale == null ? Locale.getDefault() : LocaleUtils.getLocaleForBundle((Locale)locale))).containsKey(code)) {
            return new MessageFormat(bundle.getString(code), theLocale).format(args);
        }
        if (errorStatusFallback && (status = errorStatuses.get(code)) != null && Objects.equals(code, localized)) {
            return MessageFormatter.arrayFormat((String)status.getDescription(), (Object[])args).getMessage();
        }
        return localized;
    }

    static {
        for (ErrorStatuses errorStatuses : ErrorStatuses.values()) {
            DefaultTranslationUtils.errorStatuses.put(errorStatuses.getCodeString(), (ErrorStatus)errorStatuses);
        }
        for (ErrorStatuses errorStatuses : CdsErrorStatuses.values()) {
            DefaultTranslationUtils.errorStatuses.put(errorStatuses.getCodeString(), (ErrorStatus)errorStatuses);
        }
    }
}

